using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Xml;
using System.Net;
using SlothLib.Web.Search;


namespace SlothLib.Web.Search
{
    /// <summary>
    /// FlickrAPIT[`sNX
    /// http://www.flickr.com/services/api/
    /// </summary>
    public class FlickrSearch : IImageSearch
    {

        #region vCx[gtB[h
        /// <summary>
        /// NXێAPIKey
        /// </summary>
        private string apiKey;

        // proxy
        private WebProxy proxy;

        #endregion

        #region 񋓌^

        /// <summary>
        /// NG̎
        /// </summary>
        public enum SearchType
        {
            /// <summary>
            /// eLXgNGiftHgj
            /// </summary>
            Text,
            /// <summary>
            /// ^ONG
            /// </summary>
            Tag
        }

        /// <summary>
        /// ^O̎ށiORANDj
        /// </summary>
        public enum TagMode
        {
            /// <summary>
            /// ORiftHgj
            /// </summary>
            Any,
            /// <summary>
            /// AND
            /// </summary>
            All
        }

        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^@APIKeyw肷
        /// </summary>
        /// <param name="apiKey">vOŗpAPIKey</param>

        public FlickrSearch(string apiKey)
        {
            this.apiKey = apiKey;
        }


        #endregion

        #region Proxyݒ

        /// <summary>
        /// vNV擾Eݒ肷B
        /// </summary>
        public string Proxy
        {
            set
            {
                if (string.IsNullOrEmpty(value))
                {
                    this.proxy = null;
                }
                else
                {
                    this.proxy = new WebProxy(value);
                }
            }
            get
            {
                return this.proxy.Address.AbsoluteUri;
            }
        }

        #endregion

        #region DoSearch


        /// <summary>
        /// Flickrs
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="num">擾 500ȏ500ɒu܂</param>
        /// <param name="searchType">NG̎ށ@ftHgText</param>
        /// <param name="tagMode">^O̎ށ@ftHgAny</param>
        /// <returns>FlickrResult^̌</returns>
        public FlickrSearchResult DoSearch(string query, int num, SearchType searchType, TagMode tagMode)
        {
            //AvP[VIDo^ĂȂꍇG[
            if (apiKey == "")
            {
                throw new FlickrException("No APIKey");
            }

            //gp̃AvP[VIDo
            System.Diagnostics.Debug.WriteLine("API_Key:"+apiKey);

            FlickrSearchResult searchResult = null;

            try
            {
                searchResult = DoFlickrSearch(query, num, searchType, tagMode);
            }

            catch (Exception e)
            {
                System.Diagnostics.Debug.WriteLine(e.Message);
                throw;

            }

            finally
            {

            }


            return searchResult;

        }

        #endregion

        #region DoFlickrSearch


        /// <summary>
        /// Flickrs
        /// </summary>
        /// <param name="query">NG[</param>
        /// <param name="num">擾</param>
        /// <param name="searchType">NG[̎ށ@ftHgText</param>
        /// <param name="tagMode">^O̎ށ@ftHgAny</param>
        /// <returns>FlickrResult^̌</returns>
        private FlickrSearchResult DoFlickrSearch(string query, int num, SearchType searchType, TagMode tagMode)
        {
            string requestURL = MakeFlickrQuery(query, num, searchType, tagMode);
            System.Diagnostics.Debug.WriteLine("RequestURL:"+requestURL);
            XmlDocument xmlDoc = new XmlDocument();
            try
            {

                WebRequest req = WebRequest.Create(requestURL);
                if (this.proxy != null)
                {
                    req.Proxy = proxy;
                }
                using (WebResponse res = req.GetResponse())
                using (Stream st = res.GetResponseStream())
                {
                    xmlDoc.Load(st);
                }

                // [g̗vf擾
                XmlElement xmlRoot = xmlDoc.DocumentElement;

                //[g=<rsp>vfstatfail̏ꍇ
                if (xmlRoot.GetAttribute("stat").Equals("fail"))
                {
                    string errcode = xmlRoot.FirstChild.Attributes["code"].Value;
                    string errmsg = xmlRoot.FirstChild.Attributes["msg"].Value;
                    //G[ԍƃG[bZ[WX[
                    throw new FlickrException(errcode+":"+errmsg);
                    
                }

                XmlNode xmlResultsNode = xmlRoot.FirstChild;

                // ʗvftotal̑l擾
                long resultNum = long.Parse(xmlResultsNode.Attributes["total"].Value);

                // ʗvfĂ
                List<FlickrElement> resultElementList = new List<FlickrElement>();

                XmlNodeList xmlResultList = xmlResultsNode.ChildNodes;
                int rank = 1;
                foreach (XmlElement xmlResult in xmlResultList)
                {
                    string id = xmlResult.GetAttribute("id");
                    string owner = xmlResult.GetAttribute("owner");
                    string secret = xmlResult.GetAttribute("secret");
                    string server = xmlResult.GetAttribute("server");
                    string farm = xmlResult.GetAttribute("farm");
                    string title = xmlResult.GetAttribute("title");
                    bool isPublic = BitToBoolean(xmlResult.GetAttribute("ispublic"));
                    bool isFriend = BitToBoolean(xmlResult.GetAttribute("isfriend"));
                    bool isFamily = BitToBoolean(xmlResult.GetAttribute("isfamily"));
                    FlickrElement result = new FlickrElement(id, owner, secret, server, farm, title, isPublic, isFriend, isFamily,rank);
                    rank++;
                    resultElementList.Add(result);

                }

                return new FlickrSearchResult(query, resultNum, resultElementList.ToArray());


            }
            catch
            {
                throw;
            }
        }

        #endregion

        #region MakeFlickrQuery

        /// <summary>
        /// NGXgURL쐬
        /// </summary>
        /// <param name="query">NG[</param>
        /// <param name="results">擾</param>
        /// <param name="searchType">NG[̎ށ@ftHgText</param>
        /// <param name="tagMode">^O̎ށ@ftHgAny</param>
        /// <returns>URL</returns>
        private string MakeFlickrQuery(string query, int results, SearchType searchType, TagMode tagMode)
        {
            string str = string.Empty;
            string mode = string.Empty;
            string flickrQuery = "http://api.flickr.com/services/rest/?method=flickr.photos.search";

            // Xy[Xŋ؂ꂽNGJ}ŋ؂ꂽNGɕϊ
            string csvQuery = MakeCSVQuery(query);

            // SearchTypeTagModeɂ錟^Cv̌
            switch (searchType)
            {
                case SearchType.Text:
                    str = "&text=" + csvQuery;
                    break;
                case SearchType.Tag:
                    str = "&tags=" + csvQuery;
                    break;
            }

            switch (tagMode)
            {
                case TagMode.Any:
                    mode = "&tag_mode=any";
                    break;
                case TagMode.All:
                    mode = "&tag_mode=all";
                    break;
            }

            flickrQuery += "&api_key=" + apiKey + str + "&per_page=" + results + mode;

            return flickrQuery;

        }

        #endregion

        #region MakeCSVQuery

        /// <summary>
        /// ' 'ŘAꂽNG','ŘAꂽNGɒ
        /// </summary>
        /// <param name="query">Xy[Xŋ؂ꂽNG</param>
        /// <returns>string^̃J}ŋ؂ꂽNG</returns>
        private string MakeCSVQuery(string query)
        {
            string[] array = query.Split(' ');
            string q = string.Empty;
            foreach (string s in array)
                q += s + ",";
            return q.Substring(0, q.Length - 1);

        }

        #endregion

        #region BitToBoolean

        /// <summary>
        /// "0""1"string󂯁A1ȂtrueԂAȊOȂfalseԂ
        /// </summary>
        /// <param name="bit">"0""1"̕</param>
        /// <returns>bool^̒l</returns>
        private bool BitToBoolean(string bit)
        {
            if (bit.Contains("1"))
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        #endregion

        #region GetSearchType,GetFormat

        /// <summary>
        /// NG̃^CvԂ
        /// </summary>
        /// <returns>SearchType(񋓌^) ftHg"Text"</returns>
        public static SearchType GetSearchType(string type)
        {
            SearchType st;

            switch (type.ToLowerInvariant())
            {

                case "tag":
                    st = SearchType.Tag;
                    break;
                case "text":
                    st = SearchType.Text;
                    break;
                default:
                    st = SearchType.Text; //defaultText
                    break;
            }

            return st;

        }

        /// <summary>
        /// Tag̎ނԂ
        /// </summary>
        /// <returns>TagMode(񋓌^) ftHg"Any"</returns>
        public static TagMode GetTagMode(string tagMode)
        {
            TagMode tm;

            switch (tagMode.ToLowerInvariant())
            {
                case "any":
                    tm = TagMode.Any;
                    break;
                case "all":
                    tm = TagMode.All;
                    break;
                default:
                    tm = TagMode.Any; //defaultphoto
                    break;
            }

            return tm;

        }

        #endregion

        #region IImageSearch o

        /// <summary>
        /// sʂi[
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="num">ʎ擾</param>
        /// <returns>IImageSearchResult^̌</returns>
        IImageSearchResult IImageSearch.DoSearch(string query, int num)
        {
            return DoSearch(query, num, SearchType.Text, TagMode.Any);
        }

        #endregion

        #region ISearch o

        /// <summary>
        /// sʂi[
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="num">ʎ擾</param>
        /// <returns>ISearchResult^̌</returns>
        ISearchResult ISearch.DoSearch(string query, int num)
        {
            return DoSearch(query, num, SearchType.Text, TagMode.Any);
        }

        #endregion

    }
}