using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// ʂ̃LbVɊւNX
    /// </summary>
	public class CachedSearch : ISearch
	{


		#region privatetB[h


		// LbVۑfBNg̃pX
		string cacheDir;

		// ۂɂGW
		ISearch searchEngine;

		#endregion


		#region RXgN^

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="cacheDir">LbVt@C̃fBNg</param>
		/// <param name="searchEngine">ۂ̌ɗp錟GW̃CX^X</param>
		public CachedSearch(string cacheDir, ISearch searchEngine)
		{
			if (cacheDir[cacheDir.Length - 1] != '\\')
			{
				// cacheDir̍Ōɂ͕K\悤ɕύXB
				cacheDir = cacheDir + '\\';
			}

			DirectoryInfo di = new DirectoryInfo(cacheDir);
			if (!di.Exists)
			{
				// w肳ꂽfBNg炵̂ōB
				di.Create();
			}

			this.cacheDir = cacheDir;
			this.searchEngine = searchEngine;
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="searchEngine">ۂ̌ɗp錟GW̃CX^X</param>
		public CachedSearch(ISearch searchEngine)
			: this(System.IO.Directory.GetParent(System.Reflection.Assembly.GetEntryAssembly().Location).FullName + @"\cache\", searchEngine)
		{
		}

		#endregion



		/// <summary>
		/// sB
		/// </summary>
		/// <param name="query"></param>
		/// <param name="resultNum"></param>
		/// <returns></returns>
		public ISearchResult DoSearch(string query, int resultNum)
		{
			// t@Cۑꏊ
            string filePath = this.cacheDir + this.searchEngine.GetType().Name + "_" + query.GetHashCode().ToString() + "_" + resultNum.ToString() + ".dat";

			CachedSearchResult result = this.LoadResult(filePath);
			if (result == null)
			{
				ISearchResult realResult = this.searchEngine.DoSearch(query, resultNum);
				result = new CachedSearchResult(realResult);
				this.SaveResult(result, filePath);
			}
			return result;
		}


		/// <summary>
		/// ʂLbVƂăZ[uB
		/// </summary>
		/// <param name="searchResult"></param>
		/// <param name="filePath"></param>
		private void SaveResult(CachedSearchResult searchResult, string filePath)
		{
			// OĂ邩
			using (Stream stream = new FileStream(filePath, FileMode.Create, FileAccess.Write, FileShare.None))
			{
				IFormatter formatter = new BinaryFormatter();
				try
				{
					formatter.Serialize(stream, searchResult);
				}
				catch
				{
					// O͓ȂB
				}
			}
		}


		/// <summary>
		/// LbVꂽʂ[hB
		/// </summary>
		/// <param name="filePath"></param>
		private CachedSearchResult LoadResult(string filePath)
		{
			if (File.Exists(filePath))
			{
				// OK
				using (Stream stream = new FileStream(filePath, FileMode.Open, FileAccess.Read, FileShare.Read))
				{
					IFormatter formatter = new BinaryFormatter();
					CachedSearchResult result = null;
					try
					{
						result = (CachedSearchResult)formatter.Deserialize(stream);
						return result;
					}
					catch
					{
						// sꍇAt@C͍폜Ă܂B
                        stream.Close();
						File.Delete(filePath);
						// O͓ȂB
					}
				}
			}
			// t@C݂ȂƂ⃍[hɎsꍇnullԂB
			return null;
		}


		#region ISearch o

        /// <summary>
        /// LbVꂽt@Čs
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum"></param>
        /// <returns></returns>
		ISearchResult ISearch.DoSearch(string query, int resultNum)
		{
			return this.DoSearch(query, resultNum);
		}

		#endregion
	}



	/*
	public class CachedSearch : IWebSearch
	{


        #region privatetB[h


		// LbVۑfBNg̃pX
		//string cacheDir;



		string mdbPath;


		// ۂɂWebGW
		IWebSearch webSearchEngine;





        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="cacheDir">LbVt@C̃fBNg</param>
        /// <param name="searchEngine">ۂ̌ɗp錟GW̃CX^X</param>
        public CachedSearch(string cacheDir, IWebSearch webSearchEngine)
        {
            //this.cacheDir = cacheDir;
            this.webSearchEngine = webSearchEngine;

			SetDatabase(cacheDir);
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="searchEngine">ۂ̌ɗp錟GW̃CX^X</param>
        public CachedSearch(IWebSearch webSearchEngine)
			: this(System.IO.Directory.GetParent(System.Reflection.Assembly.GetEntryAssembly().Location).FullName + @"\cache\", webSearchEngine)
        {
        }

        #endregion


		/// <summary>
		/// mdbt@C̃pXZbgB
		/// </summary>
		/// <param name="cacheDir"></param>
		private void SetDatabase(string cacheDir)
		{
			if (cacheDir[cacheDir.Length - 1] != '\\')
			{
				// cacheDir̍Ōɂ͕K\悤ɕύXB
				cacheDir = cacheDir + '\\';
			}

			DirectoryInfo di = new DirectoryInfo(cacheDir);
			if (! di.Exists)
			{
				// w肳ꂽfBNg炵̂ōB
				di.Create();
			}

			this.mdbPath = di.FullName + "SlothLib.Web.Search.CachedWebSearch.mdb";

			if (!File.Exists(mdbPath))
			{
				ADOX.CatalogClass cat = new ADOX.CatalogClass();

				cat.Create("Provider=Microsoft.Jet.OLEDB.4.0;" +
					   "Data Source=" + this.mdbPath + ";Jet OLEDB:Engine Type=5");




				ADOX.TableClass table = new ADOX.TableClass();
				table.Name = "cached_result";
				table.ParentCatalog = cat;

				table.Columns.Append("search_name", ADOX.DataTypeEnum.adVarWChar, 50);
				table.Columns.Append("setting", ADOX.DataTypeEnum.adVarWChar, 50);
				table.Columns.Append("query", ADOX.DataTypeEnum.adVarWChar, 255);
				table.Columns.Append("result_num", ADOX.DataTypeEnum.adInteger, 0);
				cat.Tables.Append(table);




				// e[u쐬(CUSTOMER)
				ADOX.TableClass table = new ADOX.TableClass();
				table.ParentCatalog = cat;
				table.Name = "TABLE1";

				// R[h̍쐬̂P(Id)
				ADOX.ColumnClass columnId = new ADOX.ColumnClass();
				columnId.ParentCatalog = cat;
				// -->ADOX.DataTypeEnum.adIntegerݒ肵ĂȂ"AutoIncrement"̐ݒŃG[ƂȂ
				columnId.Type = ADOX.DataTypeEnum.adInteger;
				columnId.Name = "Id";
				columnId.Properties["Jet OLEDB:Allow Zero Length"].Value = false;
				columnId.Properties["AutoIncrement"].Value = true;
				table.Columns.Append(columnId, ADOX.DataTypeEnum.adInteger, 0);

				// R[h̍쐬̂Q(Name)
				ADOX.ColumnClass columnName = new ADOX.ColumnClass();
				columnName.ParentCatalog = cat;
				columnName.Name = "Name";
				columnName.Properties["Jet OLEDB:Allow Zero Length"].Value = false;
				table.Columns.Append(columnName, ADOX.DataTypeEnum.adWChar, 64);

				table.Keys.Append("PrimaryKey", ADOX.KeyTypeEnum.adKeyPrimary, "Id", "", "");
				cat.Tables.Append(table);





				foreach (ADOX.Table tblll in cat.Tables)
				{
					if (tblll.Type == "TABLE")
					{
						System.Diagnostics.Debug.WriteLine(tblll.Name);
					}
				}




				// ؒf̂߂ɐFXB
				ADODB.Connection cnn = (ADODB.Connection)cat.ActiveConnection;
				cnn.Close();
				// ȂŌcatnullɂBR͕sB
				cat = null;
			}
		}





		public CachedWebElement DoSearch(string query, int resultNum)
		{

			ADODB.Connection cnn = new ADODB.Connection();
			cnn.Open("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + this.mdbPath, "", "", -1);


			ADOX.CatalogClass cat = new ADOX.CatalogClass();
			cat.ActiveConnection = cnn;

			foreach (ADOX.Table tbl in cat.Tables)
			{
				if (tbl.Type == "TABLE")
				{

				}
			}








			return null;
		}







        private ISearchResult DoCachedSearch(string query, int resultNum)
        {
            //LbVǂݍ݁BLbVꍇɂĂB
            //return LoadSearchResult(query, 0, maxResult, cacheDir);
			return null;
		}








		#region IWebSearch o

		IWebSearchResult IWebSearch.DoSearch(string query, int resultNum)
		{
			throw new Exception("The method or operation is not implemented.");
		}

		#endregion

		#region ISearch o

		ISearchResult ISearch.DoSearch(string query, int resultNum)
		{
			throw new Exception("The method or operation is not implemented.");
		}

		#endregion

	}
	*/
}
