using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using SlothLib.Web.WebLoader;

namespace SlothLibTests.Web
{
    public partial class FormWebLoaderTests : Form
    {
        private WebGetResult result = null;
        private MultiWebGetResults results = null;

        public FormWebLoaderTests()
        {
            InitializeComponent();
        }

        private void tabWebGet_Click(object sender, EventArgs e)
        {

        }



        private void buttonWebGet_Click(object sender, EventArgs e)
        {
            labelLocalFile.Text = "";
            textRespose.Text = "";
            textHeader.Text = "";


            string url = textURL.Text;
            string localFile = textLocalFile.Text;
            string[] allowContentTypes;
            string[] excludeContentTypes;

            if (string.IsNullOrEmpty(textAllowContentType.Text))
            {
                allowContentTypes = null;
            }
            else
            {
                allowContentTypes = textAllowContentType.Text.Split(new string[] { "\r\n" }, StringSplitOptions.RemoveEmptyEntries);
            }

            if (string.IsNullOrEmpty(textExcludeContentType.Text))
            {
                excludeContentTypes = null;
            }
            else
            {
                excludeContentTypes = textExcludeContentType.Text.Split(new string[] { "\r\n" }, StringSplitOptions.RemoveEmptyEntries);
            }

            WebGet webGet = new WebGet();
            WebGetResult result;
            if (string.IsNullOrEmpty(localFile))
            {
                result = webGet.DoFetch(url, allowContentTypes, excludeContentTypes);
            }
            else
            {
                result = webGet.DoFetch(url, localFile, allowContentTypes, excludeContentTypes);

            }
            if (cbExtension.Checked)
            {
                result.ChangeExtension();
            }
            if (result != null)
            {
                labelLocalFile.Text = result.LocalFilePath;
                textHeader.Text = result.Header.ToString();
                textRespose.Text = result.Response;
            }

            
        }

        private void buttonDelete_Click(object sender, EventArgs e)
        {
            if (result != null)
            {
                result.DeleteFile();
                result = null;
                labelLocalFile.Text = "";
                textRespose.Text = "";
                textHeader.Text = "";
            }

        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox6_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox4_TextChanged(object sender, EventArgs e)
        {

        }

        private void tabMultiWebGet_Click(object sender, EventArgs e)
        {

        }

        private void buttonMultiWebGet_Click(object sender, EventArgs e)
        {
            listViewResult.Items.Clear();
            textHeader.Text = "";
            textRespose.Text = "";

            string[] urlList;
            string[] outputFileList;
            string[] allowContentTypes;
            string[] excludeContentTypes;

            urlList = textURLList.Text.Split(new string[] { "\r\n" },
                StringSplitOptions.RemoveEmptyEntries);
            if (string.IsNullOrEmpty(textLocalFileList.Text))
            {
                outputFileList = null;
            }
            else
            {
                outputFileList = textLocalFileList.Text.Split(new string[] { "\r\n" },
                StringSplitOptions.RemoveEmptyEntries);
            }

            if (string.IsNullOrEmpty(textAllowContentTypes.Text))
            {
                allowContentTypes = null;
            }
            else
            {
                allowContentTypes = textAllowContentTypes.Text.Split(new string[] { "\r\n" }, StringSplitOptions.RemoveEmptyEntries);
            }

            if (string.IsNullOrEmpty(textExcludeContentTypes.Text))
            {
                excludeContentTypes = null;
            }
            else
            {
                excludeContentTypes = textExcludeContentTypes.Text.Split(new string[] { "\r\n" }, StringSplitOptions.RemoveEmptyEntries);
            }

            int threadcount = int.Parse(textThreadCount.Text);

            MultiWebGet multiWebGet = new MultiWebGet();
            multiWebGet.ThreadCount = threadcount;
            if (outputFileList == null)
            {
                results = multiWebGet.DoFetch(urlList, allowContentTypes, excludeContentTypes);
            }
            else
            {
                results = multiWebGet.DoFetch(urlList, outputFileList, allowContentTypes, excludeContentTypes);
            }

            if (cbExtensionMulti.Checked)
            {
                results.ChangeExtension();
            }

            foreach (WebGetResult re in results)
            {
                ListViewItem item = new ListViewItem();
                item.Text = re.URL;
                item.SubItems.Add(re.LocalFilePath);
                listViewResult.Items.Add(item);
            }
        }

        private void listViewResult_ItemActivate(object sender, EventArgs e)
        {

        }

        private void buttonDeleteAll_Click(object sender, EventArgs e)
        {
            if (results == null)
            {
            }
            else
            {
                results.DeleteAll();
                results = null;
                listViewResult.Items.Clear();
                textMultiResponse.Text = "";
                textMultiHeader.Text = "";
            }
        }

        private void FormWebLoaderTests_Load(object sender, EventArgs e)
        {

        }

        private void listViewResult_SelectedIndexChanged(object sender, EventArgs e)
        {
            foreach (int index in listViewResult.SelectedIndices)
            {
                textMultiResponse.Text = results[index].Response;

                textMultiHeader.Text = results[index].Header.ToString();
            }

        }
    }
}