using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormSearchCommon : Form
    {
        public FormSearchCommon()
        {
            InitializeComponent();
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            ISearch search;
            switch (cbSearchEngine.Text)
            {
                default:
                case "YahooJpWeb":
                    search = new YahooJpWebSearch("slothlib");
                    break;
                case "YahooJpImage":
                    search = new YahooJpImageSearch("slothlib");
                    break;
                case "YahooJpVideo":
                    search = new YahooJpVideoSearch("slothlib");
                    break;
                case "GoogleSOAPSearchAPI":
                    if (tbKey.Text != "")
                    {
                        search = new SlothLib.Web.Search.GoogleSOAPSearchAPI(tbKey.Text);
                    }
                    else
                    {
                        MessageBox.Show("GoogleSOAPSearchpAPIKey͂ĂB");
                        lvResult.Items.Clear();
                        lblTotalNumber.Text = "";
                        return;
                    }
                    break;
                case "GooBlog":
                    search = new GooBlogSearch();
                    break;
                case "OshieteGoo":
                    search = new OshieteGooSearch();
                    break;
                case "Flickr":
                    search = new FlickrSearch("945e41273602152763825a2c31060a35");
                    break;
                case "LiveWebSearch":
                    search = new LiveWebSearch("2990056B93288A4723E323CAEA52B9E1931BAB03");
                    break;
                case "YouTubeSearch":
                    search = new YouTubeSearch("vwQ02VPFPD4");
                    break;
            }

            ISearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.TotalNumber.ToString() + "";

            lvResult.Items.Clear();
            foreach (ISearchResultElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.Description);
                item.SubItems.Add(element.Rank.ToString());
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }
        }
    }
}