using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormOshieteGoo : Form
    {
        public FormOshieteGoo()
        {
            InitializeComponent();
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            OshieteGooSearch search;
            search = new OshieteGooSearch();


            OshieteGooSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.SearchTotalResults.ToString() + "";
            lblReturned.Text = result.ResultElements.Length.ToString();

            lblQuery.Text = result.Query;

            lvResult.Items.Clear();
            foreach (OshieteGooElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.Description);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.Author);
                item.SubItems.Add(element.Category);
                item.SubItems.Add(element.Rank.ToString());
                item.SubItems.Add(element.Date.ToString());
                
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }
        }

    }
}