using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormLiveSearch : Form
    {
        public FormLiveSearch()
        {
            InitializeComponent();
            cbLanguage.SelectedIndex = 0;
            cbSafeSearch.SelectedIndex = 0;
            cbSearchFlags.SelectedIndex = 2;

        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            LiveWebSearch search;
            search = new LiveWebSearch("2990056B93288A4723E323CAEA52B9E1931BAB03");

            LiveWebSearch.Language language = LiveWebSearch.Language.Japanese;
            LiveWebSearch.SafeSearchOptions option = LiveWebSearch.SafeSearchOptions.Moderate;
            LiveWebSearch.SearchFlags flag= LiveWebSearch.SearchFlags.None;

            switch (cbLanguage.Text)
            {
                case "Japanese":
                    language = LiveWebSearch.Language.Japanese;
                    break;
                case "English":
                    language = LiveWebSearch.Language.English;
                    break;
            }

            switch (cbSearchFlags.Text)
            {
                case "DisableHostCollapsing":
                    flag = LiveWebSearch.SearchFlags.DisableHostCollapsing;
                    break;
                case "MarkQueryWords":
                    flag = LiveWebSearch.SearchFlags.MarkQueryWords;
                    break;
                case "None":
                    flag = LiveWebSearch.SearchFlags.None;
                    break;
            }

            switch (cbSafeSearch.Text)
            {
                case "Moderate":
                    option = LiveWebSearch.SafeSearchOptions.Moderate;
                    break;
                case "Strict":
                    option = LiveWebSearch.SafeSearchOptions.Strict;
                    break;
                case "None":
                    option = LiveWebSearch.SafeSearchOptions.None;
                    break;
            }

            if (!string.IsNullOrEmpty(textFileType.Text))
            {
                search.FileType = textFileType.Text;
            }

            search.SafeSearchOption = option;
            search.SearchFrag = flag;
            search.SearchLanguage = language;

            LiveWebSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.TotalNumber.ToString() + "";
            lblResultNum.Text = result.ResultElements.Length + "";

            lblQuery.Text = result.Query;

            lvResult.Items.Clear();
            foreach (LiveWebElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.Description);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.DisplayURL);
                item.SubItems.Add(element.CacheURL);
                item.SubItems.Add(element.SearchTags);
                
                
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }
        }
    }
}