using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.LinearAlgebra.Matrix;

namespace SlothLib.PlatForm.R.LinearAlgebra.Matrix
{
    public class TransposedMatrix : StandaloneMatrix
    {
        public TransposedMatrix(IMatrix matrix)
            : base(matrix.ColumnCount, matrix.RowCount)
        {
            ROperator.Set("m", matrix.GetPlainMatrix());
            double[,] d = new double[,] { { 1, 2, 3 }, { 4, 5, 6 } };

            BasicMatrix tmpMatrix = new BasicMatrix(ROperator.Run("t(m)") as double[,]);

            int RowLength = this.RowCount;
            int ColumnLength = this.ColumnCount;
            for (int i = 0; i < RowLength; i++)
            {
                for (int j = 0; j < ColumnLength; j++)
                {
                    this[i, j] = tmpMatrix[i, j];
                }
            }

            ROperator.Close();
        }
    }
}
