﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Text.RegularExpressions;

namespace SlothLib.NLP
{
    /// <summary>
    /// 正規表現を使って語を取り除くフィルタ。
    /// StopWordFilterやPosFilterでは扱えないもの用
    /// </summary>
    /// <remarks>
    /// <newpara>[2007-05-23][inagawa]作成</newpara>
    /// </remarks>
    public class RegexFilter : AbstractStringFilter
    {
        #region private フィールド
        private Regex include;
        private Regex exclude;
        #endregion

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ。includeにマッチし、かつexcludeにマッチしないものが残る
        /// </summary>
        /// <param name="include">残したい文字列にマッチする正規表現</param>
        /// <param name="exclude">除外したい文字列にマッチする正規表現</param>
        public RegexFilter(Regex include, Regex exclude)
        {
            this.include = include;
            this.exclude = exclude;
        }

        #endregion

        /// <summary>
        /// 正規表現を使って語を取り除く
        /// </summary>
        /// <param name="str">フィルタを適用する文字列</param>
        /// <returns>フィルタ適用後の文字列</returns>
        public override string DoFilter(string str)
        {
            return Filter.RegexFilter(str, include, exclude);
        }
    }
}
