using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Text.RegularExpressions;

namespace SlothLib.NLP
{
    /// <summary>
    /// POS TaggerłSS Tagger𗘗pNX
    /// </summary>
	public class SSTaggerServer : IMorphologicalAnalyzer
	{

		/// <summary>
		/// SS Tagger̃vZX
		/// </summary>
		private static Process p = null;

		/// <summary>
		/// tagger.exe ̃pX
		/// </summary>
		private static string sstaggerPath = null;

		/// <summary>
		/// bN̂߂̃IuWFNg
		/// </summary>
		private static object lockObject = new object();

        /// <summary>
        /// Xe~Osۂ
        /// </summary>
        private static bool doStemming = false;

        /// <summary>
        /// Xe~Os߂̃tB^
        /// </summary>
        private static PorterStemmerFilter porterStemmerFilter = new PorterStemmerFilter();

		/// <summary>
		/// RXgN^
		/// </summary>
        public SSTaggerServer() { }

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="sstaggerPath">tagger.exẽpX</param>
		public SSTaggerServer(string sstaggerPath)
		{
			SSTaggerPath = sstaggerPath;
		}


		/// <summary>
		/// SS Taggers
		/// </summary>
		/// <param name="text">͑Ώۂ̃eLXg</param>
		/// <returns>͌</returns>
        public static SSTaggerResult DoSSTagger(string text)
        {
            // ̐䕶ĂSSTaggersÎō폜
            // ɂ̂悤ȕ邩Ȃ̂ł܂Ƃ߂ĐK\ŃvCXǂȂB
            text = text.Replace("\x1a", "");

            // ʊi[pB
            List<Morpheme> result = new List<Morpheme>();

            lock (lockObject)
            {
                // vZXĂȂ΁A点B
                if (p == null)
                {
                    StartProcess();
                }

                // ͂sƂɕB
                string[] splitText = text.Split(new string[] { "\r", "\n", "\r\n" }, StringSplitOptions.RemoveEmptyEntries);


                // ʂi[邽
                //StringBuilder sb = new StringBuilder();


                // 
                foreach (string input in splitText)
                {
                    p.StandardInput.WriteLine(input);
                    string line = p.StandardOutput.ReadLine();

                    // Ô߂̗O
                    if (line == null && !string.IsNullOrEmpty(input))
                    {
                        // ̃bZ[W\ꍇ͑ΉKv
                        System.Diagnostics.Debug.WriteLine("SSTaggerServer: SSTaggersI܂BċN܂BExitCode=" + p.ExitCode.ToString());
                        StopProcess();
                        StartProcess();

                        p.StandardInput.WriteLine(input);
                        line = p.StandardOutput.ReadLine();
                    }

                    string[] words = line.Split(' ');

                    foreach (string w in words)
                    {
                        int locSlash = w.LastIndexOf('/');
                        if (locSlash >= 1 && locSlash < w.Length - 1)
                        {
                            string raw = w.Substring(0, locSlash);
                            string pos = w.Substring(locSlash + 1);
                            string original = raw; //Ƃ肠rawĂ
                            if (doStemming)
                            {
                                //Xe~OsݒȂPorterStemmerFilter
                                original = porterStemmerFilter.DoFilter(raw);
                            }
                            Morpheme morpheme = new Morpheme(pos, raw, original);
                            result.Add(morpheme);
                        }
                    }
                    //sb.AppendLine(line);
                }
            }
            // System.Diagnostics.Debug.WriteLine(sb.ToString());

            return new SSTaggerResult(result);
        }

        #region Start, Stop

        /// <summary>
        /// vZXN
        /// </summary>
        public static void StartProcess()
        {
            if (string.IsNullOrEmpty(SSTaggerPath))
            {
                throw new Exception("tagger.exẽpXݒ肳Ă܂");
            }
            lock (lockObject)
            {
                // vZXĂȂ΁A点B
                if (p == null)
                {
                    // vZX̃CX^XB
                    p = new System.Diagnostics.Process();
                    // vZX StartInfo ݒ肷B
                    // st@CB
                    p.StartInfo.FileName = SSTaggerPath;
                    // qvZX̃EBhE\ȂB
                    p.StartInfo.CreateNoWindow = true;
                    //  StandardInput gpꍇ́A
                    // UseShellExecute  false ɂȂĂKv܂B
                    p.StartInfo.UseShellExecute = false;
                    // ẂAWo͂gp܂B
                    p.StartInfo.RedirectStandardInput = true;
                    p.StartInfo.RedirectStandardOutput = true;
                    //p.StartInfo.RedirectStandardError = true;

                    // JgfBNgꎞIɈړ
                    string curDirPath = Environment.CurrentDirectory;
                    FileInfo sstaggerFi = new FileInfo(SSTaggerPath);
                    // [TODO]lockŖ{ɃJgfBNgړȂ悤ɂł͕̂sB
                    lock (Environment.CurrentDirectory)
                    {
                        Environment.CurrentDirectory = sstaggerFi.DirectoryName;

                        // N܂B
                        try
                        {
                            p.Start();
                        }
                        catch
                        {
                            p = null;
                            throw;
                        }
                        finally
                        {
                            // JgfBNgɖ߂B
                            Environment.CurrentDirectory = curDirPath;
                        }
                    }
                }
            }
        }


        /// <summary>
		/// vZX~B
		/// </summary>
		public static void StopProcess()
		{
			lock (lockObject)
			{
				if (p != null)
				{
					p.Dispose();
                    p = null;
				}
			}
        }

        #endregion


        #region vpeB

        /// <summary>
		/// tagger.exẽpX
		/// </summary>
        public static string SSTaggerPath
        {
            get
            {
                return sstaggerPath;
            }
            set
            {
                string path = value;
                if (!File.Exists(path))
                {
                    if (path.EndsWith("\\") && File.Exists(path + "tagger.exe"))
                    {
                        path = path + "tagger.exe";
                    }
                    else if (File.Exists(path + "\\tagger.exe"))
                    {
                        path = path + "\\tagger.exe";
                    }
                    else
                    {
                        throw new FileNotFoundException("SSTagger is not found", path);
                    }
                }

                lock (lockObject)
                {
                    sstaggerPath = path;
                }
            }
        }

        /// <summary>
        /// Xe~Osۂ
        /// </summary>
        public static bool DoStemming
        {
            get { return doStemming; }
            set { doStemming = value; }
        }

		#endregion


		/// <summary>
		/// CX^Xp̃R}h
		/// </summary>
		/// <param name="text">͑Ώۂ̃eLXg</param>
		/// <returns>͌</returns>
		public SSTaggerResult DoAnalyze(string text)
		{
			return DoSSTagger(text);
		}



        #region IMorphologicalAnalyzer o

        IMorphologicalAnalyzerResult IMorphologicalAnalyzer.DoAnalyze(string text)
        {
            return this.DoAnalyze(text);
        }

        #endregion
    }
}
