using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.External.NLP;

namespace SlothLib.NLP
{
	/// <summary>
	/// PorterStemmer𗘗ptB^
	/// </summary>
	public class PorterStemmerFilter : AbstractStringFilter
	{
		private PorterStemmer porterStemmer;

		/// <summary>
		/// RXgN^
		/// </summary>
		public PorterStemmerFilter()
		{
			this.porterStemmer = new PorterStemmer();
		}

		/// <summary>
		/// PorterStemmer𗘗păXe~Os
		/// </summary>
		/// <param name="str">Xe~Os</param>
		/// <returns>Xe~O̕</returns>
		public override string DoFilter(string str)
		{
			return this.porterStemmer.stemTerm(str);
		}

	}
}
