using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.LinearAlgebra.Matrix;

namespace SlothLib.LinearAlgebra.R.Matrix
{
    public class EigenvalueProblemAnalyzer
    {
        public EigenvalueProblemAnalyzer()
        { }

        public EigenvalueProblemResult DoCalculate(IMatrix matrix)
        {
            ROperator.Set("m", matrix.GetPlainMatrix());

            try
            {
                ROperator.Run("r<-eigen(m)");

                double[] eigenvalue;
                double[,] eigenvector;

                eigenvalue = ROperator.Run("r$values") as double[];
                eigenvector = ROperator.Run("r$vectors") as double[,];

                ROperator.Close();

                return new EigenvalueProblemResult(eigenvalue, eigenvector);
            }
            catch (System.Runtime.InteropServices.COMException ex)
            {
                System.Diagnostics.Debug.WriteLine(ex.Message); ROperator.Close();
                ROperator.Close();

                return null;

            }
        }
    }
}
