using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// KwINX^OۂɍsNXC^[tF[X
	/// </summary>
	public interface IHierarchicalClusteringProcess<T>
	{

		/// <summary>
		/// NX^Os
		/// </summary>
		/// <returns></returns>
		HierarchicalClusteringResult<T> DoClustering();

		/// <summary>
		/// NX^Os
		/// </summary>
		/// <param name="thresholdClusterCount"></param>
		/// <returns></returns>
		HierarchicalClusteringResult<T> DoClustering(int thresholdClusterCount);

		/// <summary>
		/// NX^Os
		/// </summary>
		/// <param name="thresholdDistanceOrSimilarity"></param>
		/// <returns></returns>
		HierarchicalClusteringResult<T> DoClustering(double thresholdDistanceOrSimilarity);


		/// <summary>
		/// NX^Os
		/// </summary>
		/// <param name="thresholdClusterCount"></param>
		/// <param name="thresholdDistanceOrSimilarity"></param>
		/// <returns></returns>
		HierarchicalClusteringResult<T> DoClustering(int thresholdClusterCount, double thresholdDistanceOrSimilarity);
	}
}
