using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// Kw^NX^ǑʂłfhOێNX
	/// </summary>
	public class HierarchicalClusteringResult<T>
	{

		// fhÕm[h
		private IDendrogramNode<T>[] nodes;

		// NX^OxNgQ
		private IVector<T>[] vectors;

		// ގx
		private ClusteringDistanceType dType;

		// e[ǔvZ킪Ȃ1AގxȂ-1ێB
		private double ds;

		/// <summary>
		/// ACe
		/// </summary>
		private int itemCount;


		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="nodes"></param>
		/// <param name="vectors"></param>
		/// <param name="dType"></param>
		public HierarchicalClusteringResult(IDendrogramNode<T>[] nodes, IVector<T>[] vectors, ClusteringDistanceType dType)
		{
			this.nodes = nodes;
			this.vectors = vectors;
			this.itemCount = vectors.Length;
			this.dType = dType;
			// ގx̏ꍇ́Ae[u-1|lێĂ
			this.ds = 1;
			if (dType == ClusteringDistanceType.Similarity)
			{
				this.ds = -1;
			}
		}

		/// <summary>
		/// ʂ̐ߓ_zŕԂB
		/// ̂Ƃ̔z̏Ԃ́ANX^OŐɂ̏B
		/// </summary>
		public IDendrogramNode<T>[] DendrogramNodes
		{
			get
			{
				return this.nodes;
			}
		}



		/// <summary>
		/// NX^擾B
		/// </summary>
		/// <param name="thresholdClusterCount"></param>
		/// <param name="thresholdDistanceOrSimilarity"></param>
		/// <returns></returns>
		public ClusteringResult<T> GetClusteringResult(int thresholdClusterCount, double thresholdDistanceOrSimilarity)
		{

			/*
			// NX^Õm[hȂƂ1ȏ゠邱ƂmF
			if (this.nodes.Length < 1)
			{
				throw new Exception("NX^Ǒʂ̃m[h݂܂B");
			}
			 */

			// ܂͗ގx臒l
			double thresholdDs = thresholdDistanceOrSimilarity * this.ds;

			// ACě݃NX^ԍ
			int[] clusterID = new int[itemCount];
			// NX^̏dSxNg
			IVector<T>[] centroidVectors = new IVector<T>[itemCount];
			// ̃NX^ԍ
			for (int i = 0; i < itemCount; i++)
			{
				clusterID[i] = i;
				centroidVectors[i] = vectors[i];
			}

			// NX^݂̌̌
			int numCluster = itemCount;

			// fhOĂB
			foreach (IDendrogramNode<T> node in this.nodes)
			{
				// ~bgɒBĂI
				if (numCluster <= thresholdClusterCount || node.Distance > thresholdDs)
				{
					break;
				}

				// ҂̃NX^ɑACẽNX^IDO҂̂ɏB
				for (int i = node.ItemID2; i < itemCount; i++)
				{
					if (clusterID[i] == node.ItemID2)
					{
						clusterID[i] = node.ItemID1;
						centroidVectors[i] = node.CentroidVector;
					}
				}

				// Ƃ킯ŁANX^̐ȂȂ܂B
				numCluster--;
			}

			// ʂ̊i[pB
			List<Cluster<T>> clusterList = new List<Cluster<T>>();

			// _ŏς݂̃NX^B
			int curLoc = 0;
			// ܂킷
			for (int i = 0; i < itemCount; i++)
			{
				// NX^̑\񁁐擪B
				if (clusterID[i] == i)
				{
					// ̃NX^ɑzi[ϐ
					List<IVector<T>> members = new List<IVector<T>>();
					// ̃NX^ɑz̃CfbNXi[ϐ
					List<int> indices = new List<int>();
					// 擪͂܂͂ˁB
					members.Add(this.vectors[i]);
					indices.Add(i);
					for (int j = i + 1; j < itemCount; j++)
					{
						if (clusterID[j] == i)
						{
							members.Add(this.vectors[j]);
							indices.Add(j);
						}
					}
					clusterList.Add(new Cluster<T>(members.ToArray(), indices.ToArray(), centroidVectors[i]));
					// ̃NX^̏IB
					curLoc++;
				}
			}

			// ʂԂ܂B
			return new ClusteringResult<T>(clusterList.ToArray());
		}


		/// <summary>
		/// NX^擾B
		/// </summary>
		/// <param name="thresholdClusterCount"></param>
		/// <returns></returns>
		public ClusteringResult<T> GetClusteringResult(int thresholdClusterCount)
		{
			return GetClusteringResult(thresholdClusterCount, HierarchicalClusteringProcess<T>.INFINITE_DISTANCE * this.ds);
		}


		/// <summary>
		/// NX^擾B
		/// </summary>
		/// <param name="thresholdDistanceOrSimilarity"></param>
		/// <returns></returns>
		public ClusteringResult<T> GetClusteringResult(double thresholdDistanceOrSimilarity)
		{
			return GetClusteringResult(1, thresholdDistanceOrSimilarity);
		}




	}
}
