using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// Kw^NX^OۂɍsNX
	/// [TODO]fobOpɗO𓊂Ƃ낪cĂB
	/// </summary>
	public abstract class HierarchicalClusteringProcess<T> : IHierarchicalClusteringProcess<T>
	{

		/// <summary>
		/// ̍Œl
		/// </summary>
		public const double INFINITE_DISTANCE = System.Double.MaxValue;


		/// <summary>
		/// NX^OACeQ
		/// </summary>
		protected IVector<T>[] vectors;

		/// <summary>
		/// e[u
		/// ގx̏ꍇ͗ގx-1
		/// </summary>
		private double[,] distanceTable;

		/// <summary>
		/// ACe
		/// </summary>
		protected int itemCount;

		/// <summary>
		/// e[u쐬ɎgvZ
		/// </summary>
		protected ICalculatorScalarFromTwoVectors<T> calculator;

		/// <summary>
		/// e[ǔvZ^Cv
		/// </summary>
		protected ClusteringDistanceType dType;

		/// <summary>
		/// e[ǔvZ킪Ȃ1AގxȂ-1ێB
		/// </summary>
		protected double ds;

		/// <summary>
		/// e[ũACeA݂ǂ̃NX^ɑĂ邩
		/// </summary>
		protected int[] clusterID;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="calculator"></param>
		/// <param name="dType"></param>
		public HierarchicalClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType)
		{

			this.vectors = vectors;
			this.itemCount = vectors.Length;
			this.calculator = calculator;

			this.dType = dType;
			// ގx̏ꍇ́Ae[u-1|lێB
			this.ds = 1;
			if (dType == ClusteringDistanceType.Similarity)
			{
				this.ds = -1;
			}

			// e[u
			this.distanceTable = CreateDistanceTable(vectors);

			this.clusterID = new int[itemCount];
			for (int i = 0; i < this.itemCount; i++)
			{
				// ͂߂́Avf̃NX^
				// NX^ɂȂƂɂ́AႢ̃ACeIDNX^ԍɂȂB
				this.clusterID[i] = i;
			}
		}


		/// <summary>
		/// NX^
		/// </summary>
		/// <param name="cid1"></param>
		/// <param name="cid2"></param>
		protected abstract void Union(int cid1, int cid2);

		/// <summary>
		/// NX^1ɂȂ܂ŃNX^Os
		/// </summary>
		/// <returns></returns>
		public HierarchicalClusteringResult<T> DoClustering()
		{
			return this.DoClustering(1, INFINITE_DISTANCE);
		}

		/// <summary>
		/// NX^w肳ꂽɂȂ܂ŃNX^Os
		/// </summary>
		/// <param name="thresholdClusterCount"></param>
		/// <returns></returns>
		public HierarchicalClusteringResult<T> DoClustering(int thresholdClusterCount)
		{
			return this.DoClustering(thresholdClusterCount, INFINITE_DISTANCE);
		}

		/// <summary>
		/// NX^Os
		/// </summary>
		/// <param name="thresholdDistanceOrSimilarity">NX^O~߂臒lƂȂ鋗Bގx̏ꍇ͗ގx-1</param>
		/// <returns></returns>
		public HierarchicalClusteringResult<T> DoClustering(double thresholdDistanceOrSimilarity)
		{
			return this.DoClustering(1, thresholdDistanceOrSimilarity * this.ds);
		}

		/// <summary>
		/// NX^Os
		/// </summary>
		/// <param name="thresholdClusterCount">NX^O~߂臒lƂȂNX^</param>
		/// <param name="thresholdDistanceOrSimilarity">NX^O~߂臒lƂȂ鋗Bގx̏ꍇ͗ގx-1</param>
		/// <returns></returns>
		public HierarchicalClusteringResult<T> DoClustering(int thresholdClusterCount, double thresholdDistanceOrSimilarity)
		{
			// ŏI1ȏłB
			if (thresholdClusterCount < 1)
			{
				throw new ArgumentException("NX^̍ŏI1ȏw肵ĂB", "thresholdClusterCount");
			}

			// ܂͗ގx臒l
			double thresholdDs = thresholdDistanceOrSimilarity;

			// eACě̃NX^ID
			for (int i = 0; i < this.itemCount; i++)
			{
				// ͂߂́Avf̃NX^
				// NX^ɂȂƂɂ́AႢ̃ACeIDNX^ԍɂȂB
				this.clusterID[i] = i;
			}

			// ʂ߂
			List<IDendrogramNode<T>> nodeList = new List<IDendrogramNode<T>>();

			// ݂̃NX^
			int currentClusterCount = this.itemCount;

			// NX^OJn

			// NX^limitNum葽ꍇ͌JԂB
			while (currentClusterCount > thresholdClusterCount)
			{
				int cid1 = -1;
				int cid2 = -1;
				double minDistance = HierarchicalClusteringProcess<T>.INFINITE_DISTANCE;

				// ݂̃NX^ōł߂z߂
				for (int i = 0; i < this.itemCount - 1; i++)
				{
					if (this.clusterID[i] != i)
					{
						// NX^̑\ł͂ȂȂ玟
						continue;
					}
					for (int j = i + 1; j < this.itemCount; j++)
					{
						if (this.clusterID[j] != j)
						{
							// NX^̑\ł͂ȂȂ玟
							continue;
						}

						if (this.distanceTable[i, j] < minDistance)
						{
							minDistance = this.distanceTable[i, j];
							cid1 = i;
							cid2 = j;
						}
					}
				}

				// ~ɈĂ邩A\ȃNX^݂Ȃꍇ̓NX^O߂B
				if (minDistance > thresholdDs || (cid1 == -1 || cid2 == -1))
				{
					break;
				}

				// B
				Union(cid1, cid2);
				// ʂ̃m[hێ
				//nodeList.Add(new DendrogramNode(cid1, cid2, minDistance));
				nodeList.Add(GetDendrogramNode(cid1, cid2, minDistance));
				currentClusterCount--;
			}

			// ʁB
			HierarchicalClusteringResult<T> result = new HierarchicalClusteringResult<T>(nodeList.ToArray(), vectors, dType);
			return result;

		}

		/// <summary>
		/// fhÕm[h擾
		/// </summary>
		/// <param name="cid1"></param>
		/// <param name="cid2"></param>
		/// <param name="minDistance"></param>
		/// <returns></returns>
		protected virtual IDendrogramNode<T> GetDendrogramNode(int cid1, int cid2, double minDistance)
		{
			return new DendrogramNode<T>(cid1, cid2, minDistance);
		}



		/// <summary>
		/// NX^Ԃ̋擾
		/// </summary>
		/// <param name="cid1"></param>
		/// <param name="cid2"></param>
		/// <returns></returns>
		protected double GetDistance(int cid1, int cid2)
		{
			if (cid1 < cid2)
			{
				return this.distanceTable[cid1, cid2];
			}
			else if (cid1 > cid2)
			{
				return this.distanceTable[cid2, cid1];
			}
			else
			{
				throw new Exception("ɃANZXȂ悤Ȑ݌vɕςĂB");
				// BłȂ̂͂킴ƂłBŏIIɂ͏LOX[͏܂B
				return HierarchicalClusteringProcess<T>.INFINITE_DISTANCE;
			}
		}

		/// <summary>
		/// NX^Ԃ̋ݒ肷
		/// </summary>
		/// <param name="cid1"></param>
		/// <param name="cid2"></param>
		/// <param name="distance"></param>
		protected void SetDistance(int cid1, int cid2, double distance)
		{
			if (cid1 < cid2)
			{
				this.distanceTable[cid1, cid2] = distance;
			}
			else if (cid1 > cid2)
			{
				this.distanceTable[cid2, cid1] = distance;
			}
			else
			{
				throw new Exception("ɃANZXȂ悤Ȑ݌vɕςĂB");
				// BłȂ̂͂킴ƂłBŏIIɂ͏LOX[͏܂B
				this.distanceTable[cid1, cid2] = distance; 
			}
		}



		/// <summary>
		/// e[uvZ
		/// </summary>
		/// <returns></returns>
		private double[,] CreateDistanceTable(IVector<T>[] vectors)
		{
			/*
			// ގx̏ꍇ́Ae[u-1|lێB
			double ds = 1;
			if (this.dType == ClusteringDistanceType.Similarity)
			{
				ds = -1;
			}
			*/

			// ACe
			int count = vectors.Length;

			// e[u
			double[,] distanceTable = new double[count, count];


			// e[uvZ
			for (int i = 0; i < count - 1; i++)
			{
				for (int j = i + 1; j < count; j++)
				{
					distanceTable[i, j] = this.calculator.DoCalculate(vectors[i], vectors[j]) * this.ds;
				}
			}

			return distanceTable;
		}

	}
}
