using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// Œ@
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class CompleteLinkageClusteringProcess<T> : HierarchicalClusteringProcess<T>
	{

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="calculator"></param>
		/// <param name="dType"></param>
		public CompleteLinkageClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType)
			: base(vectors, calculator, dType)
		{
		}
		
		/// <summary>
		/// NX^
		/// </summary>
		/// <param name="cid1"></param>
		/// <param name="cid2"></param>
		protected override void Union(int cid1, int cid2)
		{
			// NX^ԍ̍XV
			clusterID[cid2] = cid1;

			// e[u̍XV
			for (int i = 0; i < this.itemCount; i++)
			{
				// NX^̑\ł͂ȂAe[ȗΊp͍XVEQƂ̑Ώۂł͂ȂB
				if (clusterID[i] != i || i == cid1 || i == cid2)
				{
					continue;
				}
				// ̏SingleLinkageł䂦B
				if (this.clusterID[i] == i && this.GetDistance(cid1, i) < this.GetDistance(cid2, i))
				{
					SetDistance(cid1, i, GetDistance(cid2, i));
				}
			}
		}

	}
}
