﻿using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.LinearAlgebra.FeatureVector;

namespace SlothLib.LinearAlgebra.FeatureVector
{

	/// <summary>
	/// クラスタリング結果保持クラス
	/// 階層型クラスタリングと非階層型クラスタリングで共通
	/// </summary>
	public class ClusteringResult<T> : IEnumerable<Cluster<T>>
	{

		// クラスタ
		private Cluster<T>[] clusters;


		/// <summary>
		/// コンストラクタ
		/// </summary>
		public ClusteringResult(Cluster<T>[] clusters)
		{
			this.clusters = clusters;
		}


		/// <summary>
		/// クラスタ数
		/// </summary>
		public int ClusterCount
		{
			get
			{
				return clusters.Length;
			}
		}




		/// <summary>
		/// クラスタ群を取得する
		/// </summary>
		/// <returns></returns>
		public Cluster<T>[] Clusters
		{
			get
			{
				return this.clusters;
			}
		}

		/// <summary>
		/// 指定されたベクトルを含むクラスタを返す。
		/// </summary>
		/// <param name="vector"></param>
		/// <returns></returns>
		public Cluster<T> GetClusterByVector(IVector<T> vector)
		{
			foreach (Cluster<T> c in this.clusters)
			{
				if (c.Contains(vector))
				{
					return c;
				}
			}
			return null;
		}

		/// <summary>
		/// 指定されたインデックスのベクトルを含むクラスタを返す。
		/// </summary>
		/// <param name="index"></param>
		/// <returns></returns>
		public Cluster<T> GetClusterByIndex(int index)
		{
			foreach (Cluster<T> c in this.clusters)
			{
				if (c.Contains(index))
				{
					return c;
				}
			}
			return null;
		}





		/// <summary>
		/// 列挙子
		/// </summary>
		/// <returns></returns>
		public IEnumerator<Cluster<T>> GetEnumerator()
		{
			return (IEnumerator<Cluster<T>>)this.clusters.GetEnumerator();
		}


		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.clusters.GetEnumerator();
		}


	}

}
