﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// ベクトルのためのIComparer
	/// </summary>
	/// <typeparam name="T"></typeparam>
	internal sealed class VectorComparer<T> : IComparer<T> 
		//where T : IEnumerable<T>
	{

		private IVector<T> vector;
		private int sortOrder;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vector"></param>
		public VectorComparer(IVector<T> vector)
		{
			this.vector = vector;
			this.sortOrder = -1;
		}


		#region IComparer<T> メンバ

		int IComparer<T>.Compare(T x, T y)
		{
			double dx = this.vector[x];
			double dy = this.vector[y];
			int ret;
			if (dx == dy)
			{
				ret = 0;
			}
			else if (dx > dy)
			{
				ret = 1;
			}
			else
			{
				ret = -1;
			}

			return ret * this.sortOrder;
		}

		#endregion
	}
}
