﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 与えられたリスト・配列に含まれているものを要素として、何回出現するかをカウントしてベクトルを作成する
	/// 例えば，語リストを与えるとtfベクトルができる
	/// </summary>
	public class FrequencyVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="keyList"></param>
		public FrequencyVector(IEnumerable<T> keyList) : base(){

			foreach (T key in keyList)
			{
				base[key] += 1.0;
			}
		}
	}
}
