using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
    /// <summary>
    /// ő̗vf1ɂȂ悤ɐK
    /// Value = Value / Max
    /// </summary>
    public class MaxNormMatrix : BasicMatrix
    {
        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="matrix"></param>
        public MaxNormMatrix(IMatrix matrix)
            : base(matrix.RowCount, matrix.ColumnCount)
        {
            double absMax = MatrixOperator.GetMaxNorm(matrix);

            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    if (absMax != 0.0)
                    {
                        this[i, j] = matrix[i, j] / absMax;
                    }
                    else
                    {
                        this[i, j] = default(double);
                    }
                }
            }
        }
    }
}
