using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
    /// <summary>
    /// ΐ
    /// Value = Log(Value + addValue)
    /// AValue0ȏ̎̂ݏL̒lvZ
    /// </summary>
	public class LogMatrix : BasicMatrix
	{
		/// <summary>
		/// RXgN^
        /// baseValue = 2.0;
        /// addValue = 1.0;
		/// </summary>
		/// <param name="matrix"></param>
		public LogMatrix(IMatrix matrix)
			: this(matrix, 2.0, 1.0)
		{ }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="matrix"></param>
        /// <param name="baseValue">log̒</param>
        /// <param name="addValue">logOɉZl</param>
        public LogMatrix(IMatrix matrix, double baseValue, double addValue)
            : base(matrix.RowCount, matrix.ColumnCount)
        {
            for (int i = 0; i < this.RowCount; i++)
            {
                for (int j = 0; j < this.ColumnCount; j++)
                {
                    if (matrix[i, j] <= 0)
                    {
                        this[i, j] = Math.Log(addValue + matrix[i, j], baseValue);
                    }
                    else
                    {
                        this[i, j] = Math.Log(matrix[i, j], baseValue);
                    }
                }
            }
        }
    }
}
