﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.IO;

namespace SlothLib.NLP
{
    /// <summary>
    /// MeCabのWebサービスであるMECAPIを利用するためのクラス。
    /// <remarks>
    /// 実際には工藤拓氏による
    /// "Yet Another MECAPI - MeCab Web Service"
    /// (http://api.chasen.org/mecapi/)
    /// を利用する。
    /// 規約等はサービスの提供元に従うこと
    /// </remarks>
    /// </summary>
    public class MECAPI : IMorphologicalAnalyzer
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MECAPI() { }

        /// <summary>
        /// 形態素解析を行う。
        /// </summary>
        /// <remarks>
        /// GETアクセスのため、解析対象のテキストサイズが大きいと結果が得られない。
        /// このメソッドは改行ごとに分割してアクセスする仕様になっているため、
        /// 適宜改行を入れるのが望ましい。
        /// </remarks>
        /// <param name="text">解析対象のテキスト</param>
        /// <returns>解析結果</returns>
        public MeCabResult DoAnalyze(string text)
        {
            string[] lines = text.Split(new string[] { "\r\n", "\n" }, StringSplitOptions.RemoveEmptyEntries);
            string responseText = "";
            foreach (string line in lines)
            {
                string param = "sentence=" + System.Web.HttpUtility.UrlEncode(text) + "&format=text";
                HttpWebRequest req = (HttpWebRequest)WebRequest.Create("http://api.chasen.org/mecapi/?" + param);

                WebResponse res = req.GetResponse();
                string response = "";
                using (Stream resStream = res.GetResponseStream())
                using (StreamReader sr = new StreamReader(resStream))
                {
                    response = sr.ReadToEnd();
                    sr.Close();
                    resStream.Close();
                }
                responseText = response.Replace("\n", "\r\n");
            }
            return new MeCabResult(responseText);
        }


        #region IMorphologicalAnalyzer メンバ

        IMorphologicalAnalyzerResult IMorphologicalAnalyzer.DoAnalyze(string text)
        {
            return this.DoAnalyze(text);
        }

        #endregion
    }
}
