/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Time
implements Serializable {
    private static final long serialVersionUID = -9022201555535589908L;
    private Calendar _value;
    private boolean isFromString;
    private String originalString;
    private static SimpleDateFormat zulu = new SimpleDateFormat("HH:mm:ss.SSSSSSSSS'Z'");

    public Time(Calendar value) {
        this._value = value;
        this._value.set(0, 0, 0);
    }

    public Time(String value) throws NumberFormatException {
        this._value = this.makeValue(value);
        this.isFromString = true;
        this.originalString = value;
    }

    public Calendar getAsCalendar() {
        return this._value;
    }

    public void setTime(Calendar date) {
        this._value = date;
        this._value.set(0, 0, 0);
    }

    public void setTime(Date date) {
        this._value.setTime(date);
        this._value.set(0, 0, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Calendar makeValue(String source) throws NumberFormatException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = null;
        if (source == null || source.length() < 8) throw new RuntimeException("invalid message string");
        if (source.length() == 8) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        } else {
            String rest = source.substring(8);
            if (rest.startsWith(".")) {
                if (rest.endsWith("Z")) {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSSSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                } else if (rest.indexOf("+") > 0 || rest.indexOf("-") > 0) {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSSSSSSSSz");
                    if (rest.lastIndexOf("+") > 0) {
                        source = source.substring(0, source.lastIndexOf("+")) + "GMT" + rest.substring(rest.lastIndexOf("+"));
                    } else if (rest.lastIndexOf("-") > 0) {
                        source = source.substring(0, source.lastIndexOf("-")) + "GMT" + rest.substring(rest.lastIndexOf("-"));
                    }
                } else {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSSSSSSSS");
                }
            } else if (rest.startsWith("Z")) {
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                if (!rest.startsWith("+") && !rest.startsWith("-")) throw new NumberFormatException("in valid time zone attribute");
                simpleDateFormat = new SimpleDateFormat("HH:mm:ssz");
                source = source.substring(0, 8) + "GMT" + rest;
            }
        }
        try {
            Date date = simpleDateFormat.parse(source);
            calendar.setTime(date);
            calendar.set(0, 0, 0);
            return calendar;
        }
        catch (ParseException e) {
            throw new RuntimeException("invalid message string");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this._value == null) {
            return "unassigned Time";
        }
        if (this.isFromString) {
            return this.originalString;
        }
        SimpleDateFormat simpleDateFormat = zulu;
        synchronized (simpleDateFormat) {
            return zulu.format(this._value.getTime());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Time)) {
            return false;
        }
        Time other = (Time)obj;
        if (this == obj) {
            return true;
        }
        boolean _equals = this._value == null && other._value == null || this._value != null && this._value.getTime().equals(other._value.getTime());
        return _equals;
    }

    public int hashCode() {
        return this._value == null ? 0 : this._value.hashCode();
    }

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

