/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.Text;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11HeaderBlockImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12Factory;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12HeaderBlockImpl;
import org.apache.axis2.saaj.PrefixedQName;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.saaj.SOAPHeaderElementImpl;

public class SOAPHeaderImpl
extends SOAPElementImpl
implements javax.xml.soap.SOAPHeader {
    private SOAPHeader omSOAPHeader;

    public SOAPHeaderImpl(SOAPHeader header) {
        super((ElementImpl)header);
        this.omSOAPHeader = header;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        return this.addHeaderElement(new PrefixedQName(null, localName, null));
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            throw new SOAPException("Namespace not declared for the give prefix: " + prefix);
        }
        return this.addChildElement(localName, prefix, namespaceURI);
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        NamespaceImpl ns = new NamespaceImpl(uri, prefix);
        Object headerBlock = null;
        headerBlock = this.element.getOMFactory() instanceof SOAP11Factory ? new SOAP11HeaderBlockImpl(localName, (OMNamespace)ns, this.omSOAPHeader, (SOAPFactory)this.element.getOMFactory()) : new SOAP12HeaderBlockImpl(localName, (OMNamespace)ns, this.omSOAPHeader, (SOAPFactory)this.element.getOMFactory());
        SOAPHeaderElementImpl soapHeaderElement = new SOAPHeaderElementImpl((SOAPHeaderBlock)headerBlock);
        this.element.setUserData("saaj.node", (Object)this, null);
        soapHeaderElement.element.setUserData("saaj.node", (Object)soapHeaderElement, null);
        soapHeaderElement.setParentElement(this);
        return soapHeaderElement;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        return this.addHeaderElement(name);
    }

    public SOAPElement addChildElement(SOAPElement soapElement) throws SOAPException {
        NamespaceImpl ns = new NamespaceImpl(soapElement.getNamespaceURI(), soapElement.getPrefix());
        Object headerBlock = null;
        headerBlock = this.element.getOMFactory() instanceof SOAP11Factory ? new SOAP11HeaderBlockImpl(soapElement.getLocalName(), (OMNamespace)ns, this.omSOAPHeader, (SOAPFactory)this.element.getOMFactory()) : new SOAP12HeaderBlockImpl(soapElement.getLocalName(), (OMNamespace)ns, this.omSOAPHeader, (SOAPFactory)this.element.getOMFactory());
        SOAPHeaderElementImpl soapHeaderElement = new SOAPHeaderElementImpl((SOAPHeaderBlock)headerBlock);
        this.element.setUserData("saaj.node", (Object)this, null);
        soapHeaderElement.element.setUserData("saaj.node", (Object)soapHeaderElement, null);
        soapHeaderElement.setParentElement(this);
        return soapHeaderElement;
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        if (name.getURI() == null || name.getURI().trim().length() == 0 || name.getPrefix() == null || name.getPrefix().trim().length() == 0) {
            throw new SOAPException("SOAP1.1 and SOAP1.2 requires all HeaderElements to have qualified namespace.");
        }
        NamespaceImpl ns = new NamespaceImpl(name.getURI(), name.getPrefix());
        Object headerBlock = null;
        headerBlock = this.element.getOMFactory() instanceof SOAP11Factory ? new SOAP11HeaderBlockImpl(name.getLocalName(), (OMNamespace)ns, this.omSOAPHeader, (SOAPFactory)this.element.getOMFactory()) : new SOAP12HeaderBlockImpl(name.getLocalName(), (OMNamespace)ns, this.omSOAPHeader, (SOAPFactory)this.element.getOMFactory());
        SOAPHeaderElementImpl soapHeaderElement = new SOAPHeaderElementImpl((SOAPHeaderBlock)headerBlock);
        this.element.setUserData("saaj.node", (Object)this, null);
        soapHeaderElement.element.setUserData("saaj.node", (Object)soapHeaderElement, null);
        soapHeaderElement.setParentElement(this);
        return soapHeaderElement;
    }

    public Iterator examineHeaderElements(String actor) {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = this.omSOAPHeader.examineHeaderBlocks(actor);
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)((NodeImpl)iterator.next())));
        }
        return elements.iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = this.omSOAPHeader.extractHeaderBlocks(actor);
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)((NodeImpl)iterator.next())));
        }
        return elements.iterator();
    }

    public Iterator examineMustUnderstandHeaderElements(String actor) {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = this.omSOAPHeader.examineMustUnderstandHeaderBlocks(actor);
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)((NodeImpl)iterator.next())));
        }
        return elements.iterator();
    }

    public Iterator examineAllHeaderElements() {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = this.omSOAPHeader.examineAllHeaderBlocks();
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)((NodeImpl)iterator.next())));
        }
        return elements.iterator();
    }

    public Iterator extractAllHeaderElements() {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = this.omSOAPHeader.extractAllHeaderBlocks();
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)((NodeImpl)iterator.next())));
        }
        return elements.iterator();
    }

    public SOAPHeaderElement addHeaderElement(QName qname) throws SOAPException {
        return (SOAPHeaderElement)this.addChildElement(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
    }

    public SOAPHeaderElement addNotUnderstoodHeaderElement(QName qname) throws SOAPException {
        SOAPHeaderBlock soapHeaderBlock = null;
        NamespaceImpl ns = new NamespaceImpl(qname.getNamespaceURI(), qname.getPrefix());
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            throw new UnsupportedOperationException();
        }
        soapHeaderBlock = this.omSOAPHeader.addHeaderBlock("NotUnderstood", this.element.getNamespace());
        soapHeaderBlock.addAttribute(qname.getLocalPart(), qname.getPrefix(), (OMNamespace)ns);
        SOAPHeaderElementImpl soapHeaderElementImpl = new SOAPHeaderElementImpl(soapHeaderBlock);
        return soapHeaderElementImpl;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(Iterator iterator) throws SOAPException {
        SOAPHeaderBlock upgrade = this.omSOAPHeader.addHeaderBlock("Upgrade", this.element.getNamespace());
        int index = 0;
        String prefix = "ns";
        while (iterator.hasNext()) {
            SOAP11HeaderBlockImpl supportedEnvelop;
            String supported = (String)iterator.next();
            NamespaceImpl namespace = new NamespaceImpl(supported, prefix + ++index);
            if (this.element.getOMFactory() instanceof SOAP11Factory) {
                supportedEnvelop = new SOAP11HeaderBlockImpl("SupportedEnvelope", (OMNamespace)namespace, (SOAPFactory)this.element.getOMFactory());
                supportedEnvelop.addAttribute("qname", prefix + index + ":" + "Envelope", null);
                upgrade.addChild((OMNode)supportedEnvelop);
                continue;
            }
            supportedEnvelop = new SOAP12HeaderBlockImpl("SupportedEnvelope", (OMNamespace)namespace, (SOAPFactory)this.element.getOMFactory());
            supportedEnvelop.addAttribute("qname", prefix + index + ":" + "Envelope", null);
            upgrade.addChild((OMNode)supportedEnvelop);
        }
        SOAPHeaderElementImpl soapHeaderElementImpl = new SOAPHeaderElementImpl(upgrade);
        return soapHeaderElementImpl;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(String[] as) throws SOAPException {
        ArrayList<String> supportedEnvelops = new ArrayList<String>();
        for (int a = 0; a < as.length; ++a) {
            String supported = as[a];
            supportedEnvelops.add(supported);
        }
        if (supportedEnvelops.size() > 0) {
            return this.addUpgradeHeaderElement(supportedEnvelops.iterator());
        }
        return null;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(String s) throws SOAPException {
        if (s == null && s.trim().length() > 0) {
            return null;
        }
        ArrayList<String> supportedEnvelops = new ArrayList<String>();
        supportedEnvelops.add(s);
        return this.addUpgradeHeaderElement(supportedEnvelops.iterator());
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            return super.addTextNode(text);
        }
        if (this.element.getOMFactory() instanceof SOAP12Factory) {
            throw new SOAPException("Cannot add text node to SOAPHeader");
        }
        return null;
    }

    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        return this.getChildren(this.element.getChildrenWithName(qName));
    }

    public Iterator getChildElements() {
        return this.getChildren(this.element.getChildren());
    }

    private Iterator getChildren(Iterator childIter) {
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            org.w3c.dom.Node domNode = (org.w3c.dom.Node)childIter.next();
            Node saajNode = this.toSAAJNode(domNode);
            if (saajNode instanceof Text) {
                childElements.add(saajNode);
                continue;
            }
            if (!(saajNode instanceof SOAPHeaderElement)) {
                SOAPHeaderElementImpl headerEle = new SOAPHeaderElementImpl((SOAPHeaderBlock)domNode);
                ((NodeImpl)domNode).setUserData("saaj.node", (Object)headerEle, null);
                childElements.add(headerEle);
                continue;
            }
            childElements.add(saajNode);
        }
        return childElements.iterator();
    }

    public void detachNode() {
        this.detach();
    }

    public OMNode detach() {
        OMNode omNode = this.omSOAPHeader.detach();
        this.parentElement = null;
        return omNode;
    }
}

