/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MultipleValueMap {
    private final HashMap m_backingMap = new HashMap();
    private int m_valueCount;
    private Object m_lastKey;
    private Object m_lastValue;

    private Object getMapped(Object key) {
        if (key != this.m_lastKey) {
            this.m_lastKey = key;
            this.m_lastValue = this.m_backingMap.get(key);
        }
        return this.m_lastValue;
    }

    public void clear() {
        this.m_backingMap.clear();
        this.m_valueCount = 0;
    }

    public int getCount(Object key) {
        Object obj = this.getMapped(key);
        if (obj instanceof MultipleValueList) {
            return ((MultipleValueList)obj).size();
        }
        if (obj == null) {
            return 0;
        }
        return 1;
    }

    public Object get(Object key, int index) {
        Object obj = this.getMapped(key);
        if (obj instanceof MultipleValueList) {
            return ((MultipleValueList)obj).get(index);
        }
        if (obj == null) {
            throw new IndexOutOfBoundsException("No value present for key");
        }
        if (index == 0) {
            return obj;
        }
        throw new IndexOutOfBoundsException("Only one value present for key");
    }

    public void add(Object key, Object value) {
        this.getMapped(key);
        if (this.m_lastValue == null) {
            this.m_backingMap.put(key, value);
            this.m_lastValue = value;
        } else if (this.m_lastValue instanceof MultipleValueList) {
            ((MultipleValueList)this.m_lastValue).add(value);
        } else {
            MultipleValueList list = new MultipleValueList();
            list.add(this.m_lastValue);
            list.add(value);
            this.m_backingMap.put(key, list);
            this.m_lastValue = list;
        }
        ++this.m_valueCount;
    }

    public List extract(Object key) {
        Object obj = this.m_backingMap.remove(key);
        if (key == this.m_lastKey) {
            this.m_lastKey = null;
            this.m_lastValue = null;
        }
        if (obj instanceof MultipleValueList) {
            return (MultipleValueList)obj;
        }
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        MultipleValueList list = new MultipleValueList();
        list.add(obj);
        return list;
    }

    public int keySize() {
        return this.m_backingMap.size();
    }

    public int valueSize() {
        return this.m_valueCount;
    }

    public boolean containsKey(Object key) {
        return this.m_backingMap.containsKey(key);
    }

    public boolean isEmpty() {
        return this.m_backingMap.isEmpty();
    }

    public Set keySet() {
        return this.m_backingMap.keySet();
    }

    private class MultipleValueList
    extends ArrayList {
    }
}

