/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.model.ClassItemWrapper;
import org.jibx.binding.model.IClass;
import org.jibx.binding.model.IClassItem;
import org.jibx.binding.model.IClassLocator;
import org.jibx.runtime.JiBXException;

public class ClassWrapper
implements IClass {
    private final IClassLocator m_locator;
    private final ClassFile m_class;
    private IClassItem[] m_fields;
    private IClassItem[] m_methods;
    static /* synthetic */ Class class$org$jibx$binding$model$ClassUtils;

    public ClassWrapper(IClassLocator loc, ClassFile clas) {
        this.m_locator = loc;
        this.m_class = clas;
    }

    protected IClassItem buildItem(ClassItem item) {
        return new ClassItemWrapper(this, item);
    }

    public String getName() {
        return this.m_class.getName();
    }

    public String getSignature() {
        return this.m_class.getSignature();
    }

    public String getPackage() {
        return this.m_class.getPackage();
    }

    public IClass getSuperClass() {
        ClassFile scf = this.m_class.getSuperFile();
        if (scf == null) {
            return null;
        }
        return new ClassWrapper(this.m_locator, this.m_class.getSuperFile());
    }

    public String[] getInterfaces() {
        return this.m_class.getInterfaces();
    }

    public String[] getInstanceSigs() {
        try {
            return this.m_class.getInstanceSigs();
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: instance signatures not found for class " + this.m_class.getName());
        }
    }

    public boolean isImplements(String sig) {
        try {
            return this.m_class.isImplements(sig);
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: instance signatures not found for class " + this.m_class.getName());
        }
    }

    public boolean isAbstract() {
        return this.m_class.isAbstract();
    }

    public boolean isInterface() {
        return this.m_class.isInterface();
    }

    public boolean isModifiable() {
        return this.m_class.isModifiable();
    }

    public boolean isSuperclass(String name) {
        for (ClassFile current = this.m_class; current != null; current = current.getSuperFile()) {
            if (!current.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public IClassItem getDirectField(String name) {
        ClassItem item = this.m_class.getDirectField(name);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    public IClassItem getField(String name) {
        try {
            return this.buildItem(this.m_class.getField(name));
        }
        catch (JiBXException e) {
            return null;
        }
    }

    public IClassItem getMethod(String name, String sig) {
        ClassItem item = this.m_class.getMethod(name, sig);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    public IClassItem getMethod(String name, String[] sigs) {
        ClassItem item = this.m_class.getMethod(name, sigs);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    public IClassItem getInitializerMethod(String sig) {
        ClassItem item = this.m_class.getInitializerMethod(sig);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    public IClassItem getStaticMethod(String name, String sig) {
        ClassItem item = this.m_class.getStaticMethod(name, sig);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    public boolean isAccessible(IClassItem item) {
        return this.m_class.isAccessible(((ClassItemWrapper)item).getClassItem());
    }

    public boolean isAssignable(IClass other) {
        String[] sigs;
        try {
            sigs = this.m_class.getInstanceSigs();
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: class information not available");
        }
        String match = other.getSignature();
        for (int i = 0; i < sigs.length; ++i) {
            if (!match.equals(sigs[i])) continue;
            return true;
        }
        return false;
    }

    public IClassItem getBestMethod(String name, String type, String[] args) {
        ClassItem item = this.m_class.getBestMethod(name, type, args);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    public ClassFile getClassFile() {
        return this.m_class;
    }

    public Class loadClass() {
        String name = this.m_class.getName();
        Class<?> clas = ClassFile.loadClass(name);
        if (clas == null) {
            try {
                clas = (class$org$jibx$binding$model$ClassUtils == null ? (class$org$jibx$binding$model$ClassUtils = ClassWrapper.class$("org.jibx.binding.model.ClassUtils")) : class$org$jibx$binding$model$ClassUtils).getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clas;
    }

    public IClassItem[] getFields() {
        if (this.m_fields == null) {
            ClassItem[] items = this.m_class.getFieldItems();
            this.m_fields = new IClassItem[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.m_fields[i] = this.buildItem(items[i]);
            }
        }
        return this.m_fields;
    }

    public IClassItem[] getMethods() {
        if (this.m_methods == null) {
            ClassItem[] items = this.m_class.getMethodItems();
            this.m_methods = new IClassItem[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.m_methods[i] = this.buildItem(items[i]);
            }
        }
        return this.m_methods;
    }

    public String getJavaDoc() {
        return null;
    }

    public IClassLocator getLocator() {
        return this.m_locator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

