/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BranchTarget;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NestedBase;
import org.jibx.runtime.JiBXException;

public class NestedCollection
extends NestedBase {
    private static final String GROWARRAY_METHOD = "org.jibx.runtime.Utility.growArray";
    private static final String GROWARRAY_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String RESIZEARRAY_METHOD = "org.jibx.runtime.Utility.resizeArray";
    private static final String RESIZEARRAY_SIGNATURE = "(ILjava/lang/Object;)Ljava/lang/Object;";
    private static final String CHECK_ISSTART_NAME = "org.jibx.runtime.impl.UnmarshallingContext.isStart";
    private static final String CHECK_ISSTART_SIGNATURE = "()Z";
    private static final String SKIP_ELEMENT_NAME = "org.jibx.runtime.impl.UnmarshallingContext.skipElement";
    private static final String SKIP_ELEMENT_SIGNATURE = "()V";
    private final String m_itemType;
    private final CollectionLoad m_loadStrategy;
    private final CollectionStore m_storeStrategy;
    private final boolean m_isOptional;

    public NestedCollection(IContainer parent, IContextObj objc, boolean ord, boolean opt, boolean flex, String type, CollectionLoad load, CollectionStore store) {
        super(parent, objc, ord, flex, false);
        this.m_itemType = type;
        this.m_loadStrategy = load;
        this.m_storeStrategy = store;
        this.m_isOptional = opt;
    }

    public String getItemType() {
        return this.m_itemType;
    }

    public boolean hasAttribute() {
        return false;
    }

    public void genAttrPresentTest(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes present");
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes present");
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes present");
    }

    public boolean hasContent() {
        return this.m_contents.size() > 0;
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        BranchWrapper link;
        if (this.m_contents.size() > 0) {
            this.m_storeStrategy.genStoreInit(mb);
            link = null;
            int count = this.m_contents.size();
            if (this.m_isOrdered) {
                for (int i = 0; i < count; ++i) {
                    if (link != null) {
                        mb.initStackState(link);
                    }
                    BranchTarget start = mb.appendTargetNOP();
                    if (link != null) {
                        link.setTarget(start, mb);
                    }
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentPresentTest(mb);
                    link = mb.appendIFEQ(this);
                    child.genContentUnmarshal(mb);
                    if (this.m_itemType != null && !ClassItem.isPrimitive(this.m_itemType)) {
                        mb.appendCreateCast(this.m_itemType);
                    }
                    this.m_storeStrategy.genStoreItem(mb);
                    mb.appendUnconditionalBranch(this).setTarget(start, mb);
                }
            } else {
                BranchTarget first = mb.appendTargetNOP();
                for (int i = 0; i < count; ++i) {
                    if (link != null) {
                        mb.targetNext(link);
                    }
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentPresentTest(mb);
                    link = mb.appendIFEQ(this);
                    child.genContentUnmarshal(mb);
                    if (this.m_itemType != null && !ClassItem.isPrimitive(this.m_itemType)) {
                        mb.appendCreateCast(this.m_itemType);
                    }
                    this.m_storeStrategy.genStoreItem(mb);
                    mb.appendUnconditionalBranch(this).setTarget(first, mb);
                }
                if (this.m_isFlexible) {
                    mb.targetNext(link);
                    mb.loadContext();
                    mb.appendCallVirtual(CHECK_ISSTART_NAME, CHECK_ISSTART_SIGNATURE);
                    link = mb.appendIFEQ(this);
                    mb.loadContext();
                    mb.appendCallVirtual(SKIP_ELEMENT_NAME, SKIP_ELEMENT_SIGNATURE);
                    mb.appendUnconditionalBranch(this).setTarget(first, mb);
                }
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
        mb.targetNext(link);
        this.m_storeStrategy.genStoreDone(mb);
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        BranchWrapper[] ifempties;
        if (this.m_contents.size() > 0) {
            BranchWrapper link = null;
            this.m_loadStrategy.genLoadInit(mb);
            int count = this.m_contents.size();
            if (this.m_isOrdered) {
                ifempties = new BranchWrapper[count];
                for (int i = 0; i < count; ++i) {
                    if (link != null) {
                        mb.initStackState(link, 1);
                    }
                    BranchTarget start = mb.appendTargetNOP();
                    ifempties[i] = this.m_loadStrategy.genLoadItem(mb);
                    mb.targetNext(link);
                    IComponent child = (IComponent)this.m_contents.get(i);
                    String type = child.getType();
                    if (count > 1) {
                        mb.appendDUP();
                        mb.appendInstanceOf(type);
                        link = mb.appendIFEQ(this);
                    }
                    if (!"java.lang.Object".equals(type) && !ClassItem.isPrimitive(type)) {
                        mb.appendCreateCast(type);
                    }
                    child.genContentMarshal(mb);
                    mb.appendUnconditionalBranch(this).setTarget(start, mb);
                }
            } else {
                BranchTarget start = mb.appendTargetNOP();
                ifempties = new BranchWrapper[]{this.m_loadStrategy.genLoadItem(mb)};
                for (int i = 0; i < count; ++i) {
                    mb.targetNext(link);
                    IComponent child = (IComponent)this.m_contents.get(i);
                    String type = child.getType();
                    if (count > 1 || !"java.lang.Object".equals(type) && !ClassItem.isPrimitive(type)) {
                        mb.appendDUP();
                        mb.appendInstanceOf(type);
                        link = mb.appendIFEQ(this);
                        mb.appendCreateCast(type);
                    }
                    child.genContentMarshal(mb);
                    mb.appendUnconditionalBranch(this).setTarget(start, mb);
                }
            }
            if (link != null) {
                mb.targetNext(link);
                mb.appendCreateNew("java.lang.StringBuffer");
                mb.appendDUP();
                mb.appendLoadConstant("Collection item of type ");
                mb.appendCallInit("java.lang.StringBuffer", "(Ljava/lang/String;)V");
                mb.appendSWAP();
                mb.appendDUP();
                BranchWrapper ifnull = mb.appendIFNULL(this);
                mb.appendCallVirtual("java.lang.Object.getClass", "()Ljava/lang/Class;");
                mb.appendCallVirtual("java.lang.Class.getName", "()Ljava/lang/String;");
                BranchWrapper toend = mb.appendUnconditionalBranch(this);
                mb.targetNext(ifnull);
                mb.appendPOP();
                mb.appendLoadConstant("NULL");
                mb.targetNext(toend);
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendLoadConstant(" has no binding defined");
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendCallVirtual("java.lang.StringBuffer.toString", "()Ljava/lang/String;");
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.appendDUP_X1();
                mb.appendSWAP();
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.appendThrow();
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
        this.m_loadStrategy.genLoadDone(mb);
        mb.targetNext(ifempties);
    }

    public boolean hasId() {
        return false;
    }

    public void genLoadId(ContextMethodBuilder mb) throws JiBXException {
        throw new IllegalStateException("No ID child");
    }

    public NameDefinition getWrapperName() {
        return null;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public void setLinkages() throws JiBXException {
        for (int i = 0; i < this.m_contents.size(); ++i) {
            ((IComponent)this.m_contents.get(i)).setLinkages();
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("collection " + (this.m_isOrdered ? "ordered" : "unordered"));
        if (this.m_itemType != null) {
            System.out.print(" (" + this.m_itemType + ")");
        }
        if (this.isFlexible()) {
            System.out.print(", flexible");
        }
        System.out.println();
        for (int i = 0; i < this.m_contents.size(); ++i) {
            IComponent comp = (IComponent)this.m_contents.get(i);
            comp.print(depth + 1);
        }
    }

    static class ArrayStore
    extends CollectionStore {
        private final String m_itemType;

        ArrayStore(String itype, boolean doubword) {
            super(doubword);
            this.m_itemType = itype;
        }

        protected void genStoreInit(ContextMethodBuilder mb) throws JiBXException {
            mb.appendLoadConstant(-1);
            mb.defineSlot(this.m_itemType, (Type)Type.INT);
        }

        protected void genStoreItem(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_itemType);
            mb.appendIncrementLocal(1, islot);
            mb.appendLoadLocal(islot);
            mb.loadObject();
            mb.appendARRAYLENGTH();
            mb.appendISUB();
            BranchWrapper ifnotfull = mb.appendIFLT(this);
            mb.loadObject();
            mb.appendCallStatic(NestedCollection.GROWARRAY_METHOD, NestedCollection.GROWARRAY_SIGNATURE);
            mb.storeObject();
            mb.targetNext(ifnotfull);
            mb.loadObject();
            this.appendSWAP(mb);
            mb.appendLoadLocal(islot);
            this.appendSWAP(mb);
            if (!ClassItem.isPrimitive(this.m_itemType)) {
                mb.appendCreateCast(this.m_itemType);
            }
            mb.appendASTORE(this.m_itemType);
        }

        protected void genStoreDone(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_itemType);
            mb.appendIncrementLocal(1, islot);
            mb.appendLoadLocal(islot);
            mb.loadObject();
            mb.appendCallStatic(NestedCollection.RESIZEARRAY_METHOD, NestedCollection.RESIZEARRAY_SIGNATURE);
            mb.storeObject();
            mb.freeSlot(this.m_itemType);
        }
    }

    static class ArrayLoad
    extends CollectionLoad {
        private final String m_itemType;
        private Object m_slotHandle = new Object();

        ArrayLoad(String itype, boolean doubword) {
            super(doubword);
            this.m_itemType = itype;
        }

        protected void genLoadInit(ContextMethodBuilder mb) throws JiBXException {
            mb.appendLoadConstant(-1);
            mb.defineSlot(this.m_slotHandle, (Type)Type.INT);
        }

        protected BranchWrapper genLoadItem(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_slotHandle);
            mb.appendIncrementLocal(1, islot);
            mb.appendLoadLocal(islot);
            mb.loadObject();
            mb.appendARRAYLENGTH();
            mb.appendISUB();
            BranchWrapper ifempty = mb.appendIFGE(this);
            mb.loadObject();
            mb.appendLoadLocal(islot);
            mb.appendALOAD(this.m_itemType);
            return ifempty;
        }

        protected void genLoadDone(ContextMethodBuilder mb) throws JiBXException {
            mb.freeSlot(this.m_slotHandle);
        }
    }

    static class AddStore
    extends CollectionStore {
        private final ClassItem m_addMethod;
        private final boolean m_isReturned;

        AddStore(ClassItem add, boolean doubword, boolean ret) {
            super(doubword);
            this.m_addMethod = add;
            this.m_isReturned = ret;
        }

        protected void genStoreItem(ContextMethodBuilder mb) throws JiBXException {
            if (!this.m_addMethod.isStatic()) {
                mb.loadObject();
                this.appendSWAP(mb);
            }
            mb.appendCall(this.m_addMethod);
            if (this.m_isReturned) {
                this.appendPOP(mb);
            }
        }
    }

    static class IteratorLoad
    extends CollectionLoad {
        private final ClassItem m_iterMethod;
        private final String m_moreName;
        private final String m_nextName;

        IteratorLoad(ClassItem iter, boolean doubword, String more, String next) {
            super(doubword);
            this.m_iterMethod = iter;
            this.m_moreName = more;
            this.m_nextName = next;
        }

        protected void genLoadInit(ContextMethodBuilder mb) throws JiBXException {
            if (!this.m_iterMethod.isStatic()) {
                mb.loadObject();
            }
            mb.appendCall(this.m_iterMethod);
            mb.defineSlot(this.m_iterMethod, Type.getType((String)"Ljava/util/Iterator;"));
        }

        protected BranchWrapper genLoadItem(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_iterMethod);
            mb.appendLoadLocal(islot);
            mb.appendCallInterface(this.m_moreName, NestedCollection.CHECK_ISSTART_SIGNATURE);
            BranchWrapper ifempty = mb.appendIFEQ(this);
            mb.appendLoadLocal(islot);
            mb.appendCallInterface(this.m_nextName, "()Ljava/lang/Object;");
            return ifempty;
        }

        protected void genLoadDone(ContextMethodBuilder mb) throws JiBXException {
            mb.freeSlot(this.m_iterMethod);
        }
    }

    static class IndexedStore
    extends CollectionStore {
        private final ClassItem m_setMethod;
        private final boolean m_isReturned;

        IndexedStore(ClassItem set, boolean doubword, boolean ret) {
            super(doubword);
            this.m_setMethod = set;
            this.m_isReturned = ret;
        }

        protected void genStoreInit(ContextMethodBuilder mb) throws JiBXException {
            mb.appendLoadConstant(-1);
            mb.defineSlot(this.m_setMethod, (Type)Type.INT);
        }

        protected void genStoreItem(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_setMethod);
            if (!this.m_setMethod.isStatic()) {
                mb.loadObject();
                this.appendSWAP(mb);
            }
            mb.appendIncrementLocal(1, islot);
            mb.appendLoadLocal(islot);
            this.appendSWAP(mb);
            mb.appendCall(this.m_setMethod);
            if (this.m_isReturned) {
                this.appendPOP(mb);
            }
        }

        protected void genStoreDone(ContextMethodBuilder mb) throws JiBXException {
            mb.freeSlot(this.m_setMethod);
        }
    }

    static class IndexedLoad
    extends CollectionLoad {
        private final ClassItem m_sizeMethod;
        private final ClassItem m_getMethod;

        IndexedLoad(ClassItem size, boolean doubword, ClassItem get) {
            super(doubword);
            this.m_sizeMethod = size;
            this.m_getMethod = get;
        }

        protected void genLoadInit(ContextMethodBuilder mb) throws JiBXException {
            mb.appendLoadConstant(-1);
            mb.defineSlot(this.m_getMethod, (Type)Type.INT);
            if (!this.m_sizeMethod.isStatic()) {
                mb.loadObject();
            }
            mb.appendCall(this.m_sizeMethod);
            mb.defineSlot(this.m_sizeMethod, (Type)Type.INT);
        }

        protected BranchWrapper genLoadItem(ContextMethodBuilder mb) throws JiBXException {
            int islot = mb.getSlot(this.m_getMethod);
            int sslot = mb.getSlot(this.m_sizeMethod);
            mb.appendIncrementLocal(1, islot);
            mb.appendLoadLocal(islot);
            mb.appendLoadLocal(sslot);
            mb.appendISUB();
            BranchWrapper ifempty = mb.appendIFGE(this);
            if (!this.m_getMethod.isStatic()) {
                mb.loadObject();
            }
            mb.appendLoadLocal(islot);
            mb.appendCall(this.m_getMethod);
            return ifempty;
        }

        protected void genLoadDone(ContextMethodBuilder mb) throws JiBXException {
            mb.freeSlot(this.m_getMethod);
            mb.freeSlot(this.m_sizeMethod);
        }
    }

    static abstract class CollectionStore
    extends CollectionBase {
        protected CollectionStore(boolean doubword) {
            super(doubword);
        }

        protected void genStoreInit(ContextMethodBuilder mb) throws JiBXException {
        }

        protected abstract void genStoreItem(ContextMethodBuilder var1) throws JiBXException;

        protected void genStoreDone(ContextMethodBuilder mb) throws JiBXException {
        }
    }

    static abstract class CollectionLoad
    extends CollectionBase {
        protected CollectionLoad(boolean doubword) {
            super(doubword);
        }

        protected void genLoadInit(ContextMethodBuilder mb) throws JiBXException {
        }

        protected abstract BranchWrapper genLoadItem(ContextMethodBuilder var1) throws JiBXException;

        protected void genLoadDone(ContextMethodBuilder mb) throws JiBXException {
        }
    }

    static abstract class CollectionBase {
        private final boolean m_isDoubleWord;

        protected CollectionBase(boolean doubword) {
            this.m_isDoubleWord = doubword;
        }

        protected void appendSWAP(MethodBuilder mb) {
            if (this.m_isDoubleWord) {
                mb.appendSWAP1For2();
            } else {
                mb.appendSWAP();
            }
        }

        protected void appendPOP(MethodBuilder mb) {
            if (this.m_isDoubleWord) {
                mb.appendPOP2();
            } else {
                mb.appendPOP();
            }
        }
    }
}

