/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.runtime.JiBXException;

public class ContextMethodBuilder
extends ExceptionMethodBuilder {
    private int m_objectSlot;
    private String m_objectType;
    private int m_contextSlot;
    private String m_contextType;
    private final boolean m_isStatic;

    public ContextMethodBuilder(String name, Type ret, Type[] args, ClassFile cf, int access, int obj, String type, int ctx, String ctype) throws JiBXException {
        super(name, ret, args, cf, access);
        this.m_objectSlot = obj;
        this.m_objectType = type;
        this.m_contextSlot = ctx;
        this.m_contextType = ctype;
        this.m_isStatic = (access & 8) != 0;
        this.addException("org.jibx.runtime.JiBXException");
    }

    public ContextMethodBuilder(String name, String sig, ClassFile cf, int access, int obj, String type, int ctx, String ctype) throws JiBXException {
        this(name, Type.getReturnType((String)sig), Type.getArgumentTypes((String)sig), cf, access, obj, type, ctx, ctype);
    }

    public ContextMethodBuilder(String name, String sig, ClassFile cf, int obj, String type, int ctx, String ctype) throws JiBXException {
        this(name, sig, cf, 17, obj, type, ctx, ctype);
    }

    public void setObjectSlot(int slot) {
        this.m_objectSlot = slot;
    }

    public void loadObject() {
        this.appendLoadLocal(this.m_objectSlot);
    }

    public void storeObject() {
        if (this.m_objectSlot < 0) {
            LocalVariableGen var = this.createLocal("obj", ClassItem.typeFromName(this.m_objectType));
            this.m_objectSlot = var.getIndex();
        } else {
            this.appendCreateCast(this.m_objectType);
            this.appendStoreLocal(this.m_objectSlot);
        }
    }

    public void loadObject(String type) {
        this.appendLoadLocal(this.m_objectSlot);
        if (!this.m_objectType.equals(type)) {
            this.appendCreateCast(this.m_objectType, type);
        }
    }

    public void loadContext() {
        this.appendLoadLocal(this.m_contextSlot);
    }

    public void loadContext(String type) {
        this.appendLoadLocal(this.m_contextSlot);
        if (!this.m_contextType.equals(type)) {
            this.appendCreateCast(this.m_contextType, type);
        }
    }

    public boolean isStaticMethod() {
        return this.m_isStatic;
    }
}

