/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jibx.binding.Loader;
import org.jibx.binding.Utility;
import org.jibx.runtime.JiBXException;

public class Run {
    private static final String BINDING_LIST_RESOURCE = "jibx_bindings.txt";
    private static final String DEFAULT_BINDING_RESOURCE = "jibx_binding.xml";

    private Run() {
    }

    private static void addBindings(InputStream is, ArrayList bindings) throws IOException {
        String line;
        BufferedReader rdr = new BufferedReader(new InputStreamReader(is));
        while ((line = rdr.readLine()) != null) {
            if (line.length() <= 0) continue;
            bindings.add(line);
        }
    }

    public static void main(String[] args) {
        block28: {
            if (args.length >= 1) {
                try {
                    int i;
                    InputStream is;
                    ArrayList<String> files = new ArrayList<String>();
                    ArrayList<String> resources = new ArrayList<String>();
                    int index = 0;
                    String target = null;
                    while (index < args.length) {
                        String arg;
                        if ("-b".equals(arg = args[index++])) {
                            if (index < args.length) {
                                files.add(args[index++]);
                                continue;
                            }
                            System.err.println("Missing binding file and target class following '-b'");
                            continue;
                        }
                        if ("-l".equals(arg)) {
                            if (index < args.length) {
                                is = new FileInputStream(args[index++]);
                                Run.addBindings(is, files);
                                ((FileInputStream)is).close();
                                continue;
                            }
                            System.err.println("Missing binding list file and target class following '-l'");
                            continue;
                        }
                        if ("-r".equals(arg)) {
                            if (index < args.length) {
                                resources.add(args[index++]);
                                continue;
                            }
                            System.err.println("Missing binding resource and target class following '-r'");
                            continue;
                        }
                        target = arg;
                        break;
                    }
                    if (target == null) break block28;
                    Loader loader = new Loader();
                    if (files.size() == 0 && resources.size() == 0) {
                        String name;
                        is = loader.getResourceAsStream(BINDING_LIST_RESOURCE);
                        if (is == null) {
                            name = target.replace('.', '/') + "_" + BINDING_LIST_RESOURCE;
                            is = loader.getResourceAsStream(name);
                        }
                        if (is != null) {
                            Run.addBindings(is, resources);
                            is.close();
                        } else {
                            name = DEFAULT_BINDING_RESOURCE;
                            is = loader.getResourceAsStream(name);
                            if (is == null) {
                                name = target.replace('.', '/') + "_" + DEFAULT_BINDING_RESOURCE;
                                is = loader.getResourceAsStream(name);
                            }
                            if (is != null) {
                                resources.add(name);
                                is.close();
                            }
                        }
                    }
                    if (files.size() == 0 && resources.size() == 0) {
                        System.err.println("No bindings found");
                        break block28;
                    }
                    for (i = 0; i < files.size(); ++i) {
                        loader.loadFileBinding((String)files.get(i));
                    }
                    for (i = 0; i < resources.size(); ++i) {
                        InputStream is2;
                        String path = (String)resources.get(i);
                        String fname = Utility.fileName(path);
                        String bname = fname;
                        int split = bname.indexOf(46);
                        if (split >= 0) {
                            bname = bname.substring(0, split);
                        }
                        if ((is2 = loader.getResourceAsStream(path)) == null) {
                            throw new IOException("Resource " + path + " not found on classpath");
                        }
                        loader.loadBinding(fname, Utility.convertName(bname), is2, null);
                    }
                    loader.processBindings();
                    Class<?> clas = loader.loadClass(target);
                    Class[] ptypes = new Class[]{args.getClass()};
                    Method main = clas.getDeclaredMethod("main", ptypes);
                    String[] pargs = new String[args.length - index];
                    System.arraycopy(args, index, pargs, 0, pargs.length);
                    Thread.currentThread().setContextClassLoader(loader);
                    main.invoke(null, new Object[]{pargs});
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (JiBXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Usage: org.jibx.binding.Run [-b binding-file][-l list-file][-r binding-resource] main-class args...");
            }
        }
    }
}

