/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport;

import java.io.IOException;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.nio.PooledParallelSender;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ReplicationTransmitter
implements ChannelSender {
    private static Log log = LogFactory.getLog(ReplicationTransmitter.class);
    private static final String info = "ReplicationTransmitter/3.0";
    protected StringManager sm = StringManager.getManager("org.apache.catalina.tribes.transport");
    private MultiPointSender transport = new PooledParallelSender();

    public String getInfo() {
        return info;
    }

    public MultiPointSender getTransport() {
        return this.transport;
    }

    public void setTransport(MultiPointSender transport) {
        this.transport = transport;
    }

    public void sendMessage(ChannelMessage message, Member[] destination) throws ChannelException {
        MultiPointSender sender = this.getTransport();
        sender.sendMessage(destination, message);
    }

    public void start() throws IOException {
        this.getTransport().connect();
    }

    public synchronized void stop() {
        this.getTransport().disconnect();
    }

    public void heartbeat() {
    }

    public synchronized void add(Member member) {
        this.getTransport().memberAdded(member);
    }

    public synchronized void remove(Member member) {
        this.getTransport().memberDisappeared(member);
    }
}

