/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.MessageSender;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelSender
implements MessageSender {
    private Log log = LogFactory.getLog((Class)ChannelSender.class);
    private Channel channel;

    public long sendToGroup(ClusteringCommand msg) throws ClusteringFault {
        if (this.channel == null) {
            return 0L;
        }
        long timeToSend = 0L;
        while (this.channel.getMembers().length > 0) {
            try {
                long start = System.currentTimeMillis();
                this.channel.send(this.channel.getMembers(), (Serializable)msg, 2);
                timeToSend = System.currentTimeMillis() - start;
                this.log.debug((Object)("Sent " + msg + " to group"));
                break;
            }
            catch (ChannelException e) {
                String message = "Error sending command message : " + msg + ". Reason " + e.getMessage();
                this.log.warn((Object)message);
            }
        }
        return timeToSend;
    }

    public void sendToSelf(ClusteringCommand msg) throws ClusteringFault {
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.send(new Member[]{this.channel.getLocalMember(true)}, (Serializable)msg, 2);
            this.log.debug((Object)("Sent " + msg + " to self"));
        }
        catch (ChannelException e) {
            throw new ClusteringFault((Exception)((Object)e));
        }
    }

    public long sendToMember(ClusteringCommand cmd, Member member) throws ClusteringFault {
        long timeToSend = 0L;
        try {
            if (member.isReady()) {
                long start = System.currentTimeMillis();
                this.channel.send(new Member[]{member}, (Serializable)cmd, 2);
                timeToSend = System.currentTimeMillis() - start;
                this.log.debug((Object)("Sent " + cmd + " to " + TribesUtil.getHost(member)));
            }
        }
        catch (ChannelException e) {
            String message = "Could not send message to " + TribesUtil.getHost(member) + ". Reason " + e.getMessage();
            this.log.warn((Object)message);
        }
        return timeToSend;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

