/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import java.io.Reader;
import java.io.StringReader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvokerUtils;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.XMLFaultCode;
import org.apache.axis2.jaxws.message.XMLFaultReason;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.dispatcher.EndpointDispatcher;
import org.apache.axis2.jaxws.server.dispatcher.factory.EndpointDispatcherFactory;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleManager;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointController {
    private static final Log log = LogFactory.getLog(EndpointController.class);
    private static final String PARAM_SERVICE_CLASS = "ServiceClass";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationContext invoke(InvocationContext ic) {
        org.apache.axis2.jaxws.core.MessageContext responseMsgContext;
        block17: {
            org.apache.axis2.jaxws.core.MessageContext requestMsgCtx = ic.getRequestMessageContext();
            String implClassName = this.getServiceImplClassName(requestMsgCtx);
            Class implClass = this.loadServiceImplClass(implClassName, requestMsgCtx.getClassLoader());
            EndpointDescription endpointDesc = this.getEndpointDescription(requestMsgCtx, implClass);
            requestMsgCtx.setEndpointDescription(endpointDesc);
            if (ic.getHandlers() == null) {
                ic.setHandlers(new HandlerResolverImpl(endpointDesc.getServiceDescription()).getHandlerChain(endpointDesc.getPortInfo()));
            }
            if (!this.bindingTypesMatch(requestMsgCtx, endpointDesc.getServiceDescription())) {
                Protocol protocol = requestMsgCtx.getMessage().getProtocol();
                if (protocol.equals((Object)Protocol.soap12)) {
                    ic.setResponseMessageContext(this.createMismatchFaultMsgCtx(requestMsgCtx, "Incoming SOAP message protocol is version 1.2, but endpoint is configured for SOAP 1.1"));
                    return ic;
                }
                if (protocol.equals((Object)Protocol.soap11)) {
                    boolean canSupport = false;
                    if (!canSupport) {
                        ic.setResponseMessageContext(this.createMismatchFaultMsgCtx(requestMsgCtx, "Incoming SOAP message protocol is version 1.1, but endpoint is configured for SOAP 1.2.  This is not supported."));
                        return ic;
                    }
                } else {
                    ic.setResponseMessageContext(this.createMismatchFaultMsgCtx(requestMsgCtx, "Incoming message protocol does not match endpoint protocol."));
                    return ic;
                }
            }
            responseMsgContext = null;
            try {
                EndpointLifecycleManager elm = this.createEndpointlifecycleManager();
                Object serviceInstance = elm.createServiceInstance(requestMsgCtx, implClass);
                this.saveRequestMessage(requestMsgCtx);
                boolean success = HandlerInvokerUtils.invokeInboundHandlers(requestMsgCtx.getMEPContext(), ic.getHandlers(), HandlerChainProcessor.MEP.REQUEST, EndpointController.isOneWay(requestMsgCtx.getAxisMessageContext()));
                if (success) {
                    EndpointDispatcher dispatcher = this.getEndpointDispatcher(implClass, serviceInstance);
                    try {
                        responseMsgContext = dispatcher.invoke(requestMsgCtx);
                    }
                    finally {
                        requestMsgCtx.getMessage().setPostPivot();
                    }
                    if (!EndpointController.isOneWay(requestMsgCtx.getAxisMessageContext())) {
                        responseMsgContext.setMEPContext(requestMsgCtx.getMEPContext());
                        HandlerInvokerUtils.invokeOutboundHandlers(responseMsgContext.getMEPContext(), ic.getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
                    }
                    break block17;
                }
                responseMsgContext = MessageContextUtils.createResponseMessageContext(requestMsgCtx);
                responseMsgContext.setMessage(requestMsgCtx.getMessage());
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            finally {
                this.restoreRequestMessage(requestMsgCtx);
            }
        }
        ic.setResponseMessageContext(responseMsgContext);
        return ic;
    }

    protected EndpointDispatcher getEndpointDispatcher(Class serviceImplClass, Object serviceInstance) throws Exception {
        EndpointDispatcherFactory factory = (EndpointDispatcherFactory)FactoryRegistry.getFactory(EndpointDispatcherFactory.class);
        return factory.createEndpointDispatcher(serviceImplClass, serviceInstance);
    }

    private Class loadServiceImplClass(String className, ClassLoader cl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to load service impl class: " + className));
        }
        try {
            Class _class = EndpointController.forName(className, true, cl);
            return _class;
        }
        catch (Throwable cnf) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr4", (String)className));
        }
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private String getServiceImplClassName(org.apache.axis2.jaxws.core.MessageContext mc) {
        MessageContext axisMsgContext = mc.getAxisMessageContext();
        AxisService as = axisMsgContext.getAxisService();
        Parameter param = as.getParameter(PARAM_SERVICE_CLASS);
        if (param == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"EndpointControllerErr2"));
        }
        String className = ((String)param.getValue()).trim();
        return className;
    }

    private EndpointDescription getEndpointDescription(org.apache.axis2.jaxws.core.MessageContext mc, Class implClass) {
        AxisService axisSvc = mc.getAxisMessageContext().getAxisService();
        if (axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription") != null) {
            Parameter param = axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
            EndpointDescription ed = (EndpointDescription)param.getValue();
            return ed;
        }
        ServiceDescription sd = DescriptionFactory.createServiceDescriptionFromServiceImpl((Class)implClass, (AxisService)axisSvc);
        EndpointDescription ed = (EndpointDescription)sd.getEndpointDescriptions_AsCollection().iterator().next();
        return ed;
    }

    private EndpointLifecycleManager createEndpointlifecycleManager() {
        EndpointLifecycleManagerFactory elmf = (EndpointLifecycleManagerFactory)FactoryRegistry.getFactory(EndpointLifecycleManagerFactory.class);
        return elmf.createEndpointLifecycleManager();
    }

    private boolean bindingTypesMatch(org.apache.axis2.jaxws.core.MessageContext requestMsgCtx, ServiceDescription serviceDesc) {
        Collection eds = serviceDesc.getEndpointDescriptions_AsCollection();
        if (eds != null && eds.size() > 0) {
            EndpointDescription ed = (EndpointDescription)eds.iterator().next();
            Protocol protocol = requestMsgCtx.getMessage().getProtocol();
            String endpointBindingType = ed.getBindingType();
            if (protocol.equals((Object)Protocol.soap11)) {
                return "http://schemas.xmlsoap.org/wsdl/soap/http".equalsIgnoreCase(endpointBindingType) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equalsIgnoreCase(endpointBindingType);
            }
            if (protocol.equals((Object)Protocol.soap12)) {
                return "http://www.w3.org/2003/05/soap/bindings/HTTP/".equalsIgnoreCase(endpointBindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equalsIgnoreCase(endpointBindingType);
            }
            if (protocol.equals((Object)Protocol.rest)) {
                return "http://www.w3.org/2004/08/wsdl/http".equalsIgnoreCase(endpointBindingType);
            }
        }
        return true;
    }

    private org.apache.axis2.jaxws.core.MessageContext createMismatchFaultMsgCtx(org.apache.axis2.jaxws.core.MessageContext requestMsgCtx, String errorMsg) {
        try {
            XMLFault xmlfault = new XMLFault(XMLFaultCode.VERSIONMISMATCH, new XMLFaultReason(errorMsg));
            Message msg = ((MessageFactory)FactoryRegistry.getFactory(MessageFactory.class)).create(Protocol.soap11);
            msg.setXMLFault(xmlfault);
            org.apache.axis2.jaxws.core.MessageContext responseMsgCtx = MessageContextUtils.createFaultMessageContext(requestMsgCtx);
            responseMsgCtx.setMessage(msg);
            return responseMsgCtx;
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private void saveRequestMessage(org.apache.axis2.jaxws.core.MessageContext requestMsgContext) {
        Boolean value = (Boolean)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG");
        if (value != null && value == Boolean.TRUE) {
            Message m = requestMsgContext.getMessage();
            String savedMsg = m.getAsOMElement().toString();
            requestMsgContext.getAxisMessageContext().setProperty("org.apache.axis2.jaxws.spi.SAVED_REQUEST_MSG_TEXT", (Object)savedMsg);
        }
    }

    private void restoreRequestMessage(org.apache.axis2.jaxws.core.MessageContext requestMsgContext) {
        String savedMsg;
        Boolean value = (Boolean)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG");
        if (value != null && value == Boolean.TRUE && (savedMsg = (String)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVED_REQUEST_MSG_TEXT")) != null && savedMsg.length() > 0) {
            try {
                StringReader sr = new StringReader(savedMsg);
                XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((Reader)sr);
                MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
                Protocol protocol = requestMsgContext.getAxisMessageContext().isDoingREST() ? Protocol.rest : null;
                Message msg = mf.createFrom(xmlreader, protocol);
                requestMsgContext.setMessage(msg);
            }
            catch (Throwable e) {
                ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
    }

    public static boolean isOneWay(MessageContext mc) {
        AxisOperation op;
        String mep;
        return mc != null && ((mep = (op = mc.getAxisOperation()).getMessageExchangePattern()).equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only"));
    }
}

