/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequestFactory;
import org.apache.http.RequestLine;
import org.apache.http.impl.nio.codecs.HttpMessageParser;
import org.apache.http.impl.nio.reactor.SessionInputBuffer;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public class HttpRequestParser
extends HttpMessageParser {
    private final HttpRequestFactory requestFactory;

    public HttpRequestParser(SessionInputBuffer buffer, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, params);
        if (requestFactory == null) {
            throw new IllegalArgumentException("Request factory may not be null");
        }
        this.requestFactory = requestFactory;
    }

    protected HttpMessage createMessage(CharArrayBuffer buffer) throws HttpException {
        RequestLine requestLine = BasicRequestLine.parse((CharArrayBuffer)buffer, (int)0, (int)buffer.length());
        return this.requestFactory.newHttpRequest(requestLine);
    }
}

