/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import java.util.Vector;

public class Rights
implements Cloneable {
    private boolean[] rights = new boolean[128];

    public Rights() {
    }

    public Rights(Rights rights) {
        System.arraycopy(rights.rights, 0, this.rights, 0, this.rights.length);
    }

    public Rights(String rights) {
        int i = 0;
        while (i < rights.length()) {
            this.add(Right.getInstance(rights.charAt(i)));
            ++i;
        }
    }

    public Rights(Right right) {
        this.rights[right.right] = true;
    }

    public void add(Right right) {
        this.rights[right.right] = true;
    }

    public void add(Rights rights) {
        int i = 0;
        while (i < rights.rights.length) {
            if (rights.rights[i]) {
                this.rights[i] = true;
            }
            ++i;
        }
    }

    public void remove(Right right) {
        this.rights[right.right] = false;
    }

    public void remove(Rights rights) {
        int i = 0;
        while (i < rights.rights.length) {
            if (rights.rights[i]) {
                this.rights[i] = false;
            }
            ++i;
        }
    }

    public boolean contains(Right right) {
        return this.rights[right.right];
    }

    public boolean contains(Rights rights) {
        int i = 0;
        while (i < rights.rights.length) {
            if (rights.rights[i] && !this.rights[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rights)) {
            return false;
        }
        Rights rights = (Rights)obj;
        int i = 0;
        while (i < rights.rights.length) {
            if (rights.rights[i] != this.rights[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.rights.length) {
            if (this.rights[i]) {
                ++hash;
            }
            ++i;
        }
        return hash;
    }

    public Right[] getRights() {
        Vector<Right> v = new Vector<Right>();
        int i = 0;
        while (i < this.rights.length) {
            if (this.rights[i]) {
                v.addElement(Right.getInstance((char)i));
            }
            ++i;
        }
        Object[] rights = new Right[v.size()];
        v.copyInto(rights);
        return rights;
    }

    public Object clone() {
        Rights r = null;
        try {
            r = (Rights)super.clone();
            r.rights = new boolean[128];
            System.arraycopy(this.rights, 0, r.rights, 0, this.rights.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return r;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.rights.length) {
            if (this.rights[i]) {
                sb.append((char)i);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final class Right {
        private static Right[] cache = new Right[128];
        public static final Right LOOKUP = Right.getInstance('l');
        public static final Right READ = Right.getInstance('r');
        public static final Right KEEP_SEEN = Right.getInstance('s');
        public static final Right WRITE = Right.getInstance('w');
        public static final Right INSERT = Right.getInstance('i');
        public static final Right POST = Right.getInstance('p');
        public static final Right CREATE = Right.getInstance('c');
        public static final Right DELETE = Right.getInstance('d');
        public static final Right ADMINISTER = Right.getInstance('a');
        char right;

        private Right(char right) {
            if (right >= '\u0080') {
                throw new IllegalArgumentException("Right must be ASCII");
            }
            this.right = right;
        }

        public static synchronized Right getInstance(char right) {
            if (right >= '\u0080') {
                throw new IllegalArgumentException("Right must be ASCII");
            }
            if (cache[right] == null) {
                Right.cache[right] = new Right(right);
            }
            return cache[right];
        }

        public String toString() {
            return String.valueOf(this.right);
        }
    }
}

