package jp.sourceforge.shovel.service;

import javax.transaction.TransactionManager;

import jp.sourceforge.shovel.SizeType;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IServerFileService {
    void createServerFile(IServerFile serverFile, boolean thumbnail, boolean detectEncoding) throws ApplicationException;
    void removeServerFile(IServerFile serverFile) throws ApplicationException;
    boolean createThumbnail(IServerFile serverFile, SizeType sizeType) throws ApplicationException;
    
    void setTransactionManager(TransactionManager transactionManager);
}
