package jp.sourceforge.shovel.service;

import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IDirectoryService {
    IUser createUser(String displayName, String foreignKey, String password, String email, IServerFile serverFile,
            String location, String timeZoneId, String description, boolean protect, boolean cache) throws ApplicationException;
    IUser createTemporaryUser();
    IUser login(String foreignKey, String password, boolean once);
    void logout();
    IUser getLoginUser();
    IUser getUser(long userId);
    IUser getUser(String foreignKey);
    IUser getUser(String foreignKey, boolean email);
    IUser[] getUsers(SortType sortType, SortOrderType sortOrderType, int limit);
    IUser[] getUsers(long[] userIds);
    IUser[] getUsers(String[] foreignKeys);
    IUser[] searchUsers(String keyword, int page, int limit);
    IUser[] getRandUsers();
    
    int removeUser(long userId) throws ApplicationException;
    int removeUsers(long[] userIds);
    int updateUser(IUser user) throws ApplicationException;
    int updateUserFromImportCsv(IUser user) throws ApplicationException;
    int updateUserFromSettings(IUser user) throws ApplicationException;
    int updateNotices(RepliesType repliesType, boolean follow, boolean reply, boolean directMessage, boolean growl, String growlHost, String growlPassword) throws ApplicationException;
    int updatePassword(IUser user, String password);
    int updatePicture(long serverFileId);
    
    int incrementFavorites(long userId);
    int incrementFavorites(String foreignKey);
    int incrementGivenFavorites(long userId);
    int incrementGivenFavorites(String foreignKey);
    int incrementStatuses(long userId);
    int incrementStatuses(String foreignKey);
    int incrementDirectMessages(long userId);
    int incrementDirectMessages(String foreignKey);
    int decrementFavoritesAll(long statusId);
    int decrementFavorites(long userId);
    int decrementFavorites(String foreignKey);
    int decrementGivenFavorites(long userId);
    int decrementGivenFavorites(String foreignKey);
    int decrementStatuses(long userId);
    int decrementStatuses(String foreignKey);
    int decrementDirectMessages(long userId);
    int decrementDirectMessages(String foreignKey);
}
