package jp.sourceforge.shovel.form.impl;

import static jp.sourceforge.shovel.MethodType.*;
import static jp.sourceforge.shovel.SortOrderType.*;
import static jp.sourceforge.shovel.SystemConfigType.*;

import org.seasar.struts.annotation.tiger.StrutsActionForm;


import jp.sourceforge.shovel.MethodType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SystemConfigType;
import jp.sourceforge.shovel.form.ISystemForm;

@StrutsActionForm(name = "systemForm")
public class SystemFormImpl implements ISystemForm {
    SortOrderType sortOrderType_;
    SystemConfigType configType_;
    MethodType methodType_;
    int page_;
    boolean partial_;
    long userId_;
    
    public String getConfig() {
        return getConfigType().getForward();
    }
    public void setConfig(String config) {
        setConfigType(SystemConfigType.find(config));
    }
    public SystemConfigType getConfigType() {
        return configType_ == null ? ACCOUNTS : configType_;
    }
    void setConfigType(SystemConfigType configType) {
        configType_ = configType;
    }
    public String getMethod() {
        return getMethodType().getId();
    }
    public void setMethod(String method) {
        setMethodType(MethodType.find(method));
    }
    public MethodType getMethodType() {
        return methodType_ == null ? RELOAD : methodType_;
    }
    void setMethodType(MethodType methodType) {
        methodType_ = methodType;
    }
    public int getPage() {
        return page_;
    }
    public void setPage(int page) {
        page_ = page;
    }
    public boolean isPartial() {
        return partial_;
    }
    public void setPartial(boolean partial) {
        partial_ = partial;
    }
    public String getSortOrder() {
        return getSortOrderType().getSortOrder();
    }
    public void setSortOrder(String sortOrder) {
        setSortOrderType(SortOrderType.find(sortOrder));
    }
    public SortOrderType getSortOrderType() {
        return sortOrderType_ == null ? DESC : sortOrderType_;
    }
    void setSortOrderType(SortOrderType sortOrderType) {
        sortOrderType_ = sortOrderType;
    }
    public long getUserId() {
        return userId_;
    }
    public void setUserId(long userId) {
        userId_ = userId;
    }
}
