package jp.sourceforge.shovel.filter.config;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonFilterConfig {
    int flag = Pattern.CASE_INSENSITIVE;
    List<Pattern> patterns = new ArrayList<Pattern>();

    public void setFlag(int flag) {
        this.flag = flag;
    }
    public void addPattern(String s) {
        Pattern pattern = Pattern.compile( s, this.flag );
        this.patterns.add( pattern );
    }
    public boolean isFind(String path) {
        for (Pattern p : this.patterns) {
            Matcher m = p.matcher(path);
            if (m.find()) {
                return true;
            }
        }
        return false;
    }
}
