package jp.sourceforge.shovel.entity.impl;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.internet.MimeUtility;

import jp.sourceforge.shovel.entity.IClient;
import jp.sourceforge.shovel.exception.ApplicationException;

public class NetscapeImpl extends AbstractClientImpl implements IClient
{
    public String getApplication() {
        return "netscape";
    }
    public static IClient testUserAgent(String userAgent) {
        IClient client = null;
        Matcher m = Pattern.compile("mozilla/(([0-9])[0-9\\.]+)").matcher(userAgent);
        if (m.find()) {
            client = (IClient)getContainer().getComponent(NetscapeImpl.class);
            if (m.group(1).equals("5") && userAgent.indexOf("msie") == -1 &&
                    userAgent.indexOf("firefox") != -1 && userAgent.indexOf("safari") != -1) {
                m = Pattern.compile("netscape/([0-9\\.]+)").matcher(userAgent);
                if (m.find()) {
                    client.setVersion(m.group());
                }
            } else {
                client.setVersion(m.group(0));
            }
        }
        return client;
    }
    public String encodeText(String text) throws ApplicationException {
        try {
            return MimeUtility.encodeText(text, "UTF-8", "B");
        } catch (UnsupportedEncodingException ex) {
            throw new ApplicationException("");
        }
    }
}
