package jp.sourceforge.shovel.entity.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.shovel.entity.IClient;
import jp.sourceforge.shovel.exception.ApplicationException;

public class InternetExplorerImpl extends AbstractClientImpl implements IClient {
    public String getApplication() {
        return "ie";
    }
    public static IClient testUserAgent(String userAgent) {
        IClient client = null;
        if (userAgent.matches("^mozilla/.+\\(compatible; msie .+;.+\\)")) {
            Matcher m = Pattern.compile("opera ([0-9\\.]+)").matcher(userAgent);
            if (!m.find()) {
                client = (IClient)getContainer().getComponent(InternetExplorerImpl.class);
                int pos = userAgent.indexOf("msie");
                int end = userAgent.indexOf(";", pos + 5);
                String version = userAgent.substring(pos + 5, end);
                client.setVersion(version);
            }
        }
        return client;
    }
    public String encodeText(String text) throws ApplicationException {
        return text;
    }
}
