package jp.sourceforge.shovel.entity.impl;

import java.util.Map;
import java.util.LinkedHashMap;

import jp.sourceforge.shovel.GrowlPriorityType;
import jp.sourceforge.shovel.GrowlType;
import jp.sourceforge.shovel.entity.IGrowlPacket;

public class GrowlPacketImpl implements IGrowlPacket {
    String application_;
    String password_;
    GrowlType growlType_;
    //Registration
    String notification_;
    Map<String, Boolean> notificationMap_;
    String title_;
    String description_;
    GrowlPriorityType priorityType_;
    boolean sticky_;
    
    public String getApplication() {
        return application_;
    }
    public void setApplication(String application) {
        application_ = application;
    }
    public String getPassword() {
        return password_;
    }
    public void setPassword(String password) {
        password_ = password;
    }
    public GrowlType getGrowlType() {
        return growlType_;
    }
    public void setGrowlType(GrowlType growlType) {
        growlType_ = growlType;
    }
    public String getNotification() {
        return notification_;
    }
    public void setNotification(String notification) {
        notification_ = notification;
    }
    public void addNotification(String notification, boolean enabled) {
        if (notificationMap_ == null) {
            notificationMap_ = new LinkedHashMap<String, Boolean>();
        }
        notificationMap_.put(notification, enabled);
    }
    public Map<String, Boolean> getNotifications() {
        return notificationMap_;
    }
    public String getTitle() {
        return title_;
    }
    public void setTitle(String title) {
        title_ = title;
    }
    public String getDescription() {
        return description_;
    }
    public void setDescription(String description) {
        description_ = description;
    }
    public GrowlPriorityType getPriorityType() {
        return priorityType_;
    }
    public void setPriorityType(GrowlPriorityType priorityType) {
        priorityType_ = priorityType;
    }
    public boolean isSticky() {
        return sticky_;
    }
    public void setSticky(boolean sticky) {
        sticky_ = sticky;
    }
}
