package jp.sourceforge.shovel.entity;

import java.awt.Color;
import java.util.TimeZone;

import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IUser {
    boolean isAdministrator();
    void setAdministrator(boolean administrator);
    long getCreatedTime();
    void setCreatedTime(long createdTime);
    long getCreatorId();
    void setCreatorId(long creatorId);
    boolean isDefaultDesign();
    void setDefaultDesign(boolean defaultDesign);
    String getDescription();
    void setDescription(String description);
    int getDirectMessages();
    void setDirectMessages(int directMessages);
    String getDisplayName();
    void setDisplayName(String displayName);
    String getEmail();
    void setEmail(String email);
    int getFavorites();
    void setFavorites(int favorites);
    String getForeignKey();
    void setForeignKey(String foreignKey);
    int getGivenFavorites();
    void setGivenFavorites(int givenFavorites);
    String getLocation();
    void setLocation(String location);
    long getModifiedTime();
    void setModifiedTime(long modifiedTime);
    long getModifierId();
    void setModifierId(long modifierId);
    String getPassword();
    void setPassword(String password);
    boolean isProtect();
    void setProtect(boolean protect);
    int getRequests();
    void setRequests(int requests);
    long getProfileImageId();
    void setProfileImageId(long profileImageId);
    long getBackgroundImageId();
    void setBackgroundImageId(long backgroundImageId);
    boolean isTile();
    void setTile(boolean tile);
    String getTimeZoneId();
    void setTimeZoneId(String tzId);
    //TODO バージョンアップが可能になったらスキーマもろともfriendsに
    int getStatuses();
    void setStatuses(int statuses);
    boolean isRemove();
    void setRemove(boolean remove);
    int getReplies();
    void setReplies(int replies);
    RepliesType getRepliesType();
    void setRepliesType(RepliesType repliesType);
    long getUserId();
    void setUserId(long userId);
    int getViewLines();
    void setViewLines(int viewLines);
    String getBackgroundColorHex();
    void setBackgroundColorHex(String hex);
    Color getBackgroundColor();
    String getColorHex();
    void setColorHex(String hex);
    Color getColor();
    String getNameColorHex();
    void setNameColorHex(String hex);
    Color getNameColor();
    String getLinkColorHex();
    void setLinkColorHex(String hex);
    Color getLinkColor();
    String getSidebarBackgroundColorHex();
    void setSidebarBackgroundColorHex(String hex);
    Color getSidebarBackgroundColor();
    String getSidebarFrameColorHex();
    void setSidebarFrameColorHex(String hex);
    Color getSidebarFrameColor();
    boolean isNewFriends();
    void setNewFriends(boolean newFriends);
    boolean isReply();
    void setReply(boolean reply);
    boolean isRecipientDirectMessage();
    void setRecipientDirectMessage(boolean recipientDirectMessage);
    boolean isGrowl();
    void setGrowl(boolean growl);
    String getGrowlHost();
    void setGrowlHost(String growlHost);
    String getGrowlPassword();
    void setGrowlPassword(String growlPassword);
    
    /////
    
    String getProfileImageCharset();
    void setProfileImageCharset(String charset);
    String getProfileImageMime();
    void setProfileImageMime(String mime);
    String getProfileImageName();
    void setProfileImageName(String name);
    int getProfileImageSize();
    void setProfileImageSize(int size);
    int getProfileImageWidth();
    void setProfileImageWidth(int width);
    int getProfileImageHeight();
    void setProfileImageHeight(int height);
    long getProfileImageCreatedTime();
    void setProfileImageCreatedTime(long createdTime);
    
    /////
    
    String getBackgroundImageCharset();
    void setBackgroundImageCharset(String charset);
    String getBackgroundImageMime();
    void setBackgroundImageMime(String mime);
    String getBackgroundImageName();
    void setBackgroundImageName(String name);
    int getBackgroundImageSize();
    void setBackgroundImageSize(int size);
    int getBackgroundImageWidth();
    void setBackgroundImageWidth(int width);
    int getBackgroundImageHeight();
    void setBackgroundImageHeight(int height);
    long getBackgroundImageCreatedTime();
    void setBackgroundImageCreatedTime(long createdTime);
    
    /////
    
    int getFollowing();
    void setFollowing(int following);
    int getFollowers();
    void setFollowers(int followers);
    String getAddress();
    void setAddress(String address);
    int getAvailability();
    void setAvailability(int availability);
    long getDeviceId();
    void setDeviceId(long deviceId);
    String getType();
    void setType(String type);
    
    /////
    
    IStatus getRecentlyStatus();
    void setRecentlyStatus(IStatus status);
    
    String getBody();
    void setBody(String body);
    String getSource();
    void setSource(String source);
    long getReferenceId();
    void setReferenceId(long referenceId);
    long getReferenceSenderId();
    void setReferenceSenderId(long referenceSenderId);
    long getSenderId();
    void setSenderId(long senderId);
    long getSentTime();
    void setSentTime(long sentTime);
    long getStatusId();
    void setStatusId(long statusId);
    long getRemovedTime();
    void setRemovedTime(long removedTime);
    
    /////
    
    TimeZone getTimeZone();
    void setTimeZone(TimeZone timeZone);
    IServerFile getProfileImage();
    void setProfileImage(IServerFile profileImage);
    IServerFile getBackgroundImage();
    void setBackgroundImage(IServerFile backgroundImage);
    IDevice getDevice();
    void setDevice(IDevice device);
    String getReleaseKey() throws ApplicationException;
}
