package jp.sourceforge.shovel.device.impl;

import static org.seasar.framework.container.ContainerConstants.*;

import javax.servlet.http.HttpServletRequest;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.DelayExecutionType;
import jp.sourceforge.shovel.device.IDelayExecutorContext;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;

public class DelayExecutorContextImpl implements IDelayExecutorContext {
    DelayExecutionType type_;
    boolean commit_;
    IStatus status_;
    IDirectMessage directMessage_;
    IFavorite favorite_;
    IFriendship friend_;
    IUser user_;
    String server_;
    
    public void setDelayExecutionType(DelayExecutionType type) {
        type_ = type;
    }
    public DelayExecutionType getDelayExecutionType() {
        return type_;
    }
    
    public boolean isCommit() {
        return commit_;
    }
    public void setCommit(boolean commit) {
        commit_ = commit;
    }
    
    public IStatus getStatus() {
        return status_;
    }
    public void setStatus(IStatus status) {
        status_ = status;
    }
    public IDirectMessage getDirectMessage() {
        return directMessage_;
    }
    public void setDirectMessage(IDirectMessage directMessage) {
        directMessage_ = directMessage;
    }
    public IFavorite getFavorite() {
        return favorite_;
    }
    public void setFavorite(IFavorite favorite) {
        favorite_ = favorite;
    }
    public IFriendship getFriend() {
        return friend_;
    }
    public void setFriend(IFriendship friend) {
        friend_ = friend;
    }
    public IUser getUser() {
        return user_;
    }
    public void setUser(IUser user) {
        user_ = user;
    }
    
    public void initServerName() {
        String host = getRequest().getServerName();
        int port = getRequest().getServerPort();
        StringBuilder builder = new StringBuilder(host);
        if (port > 0) {
            builder.append(":");
            builder.append(port);
        }
        server_ = builder.toString();
    }
    public String getServerName() {
        return server_;
    }
    
    /////////////////////////
    
    S2Container container_;
    
    public void setContainer(S2Container container) {
        container_ = container;
    }
    S2Container getContainer() {
        return container_;
    }
    HttpServletRequest getRequest() {
        return (HttpServletRequest)getContainer().getComponent(REQUEST_NAME);
    }
}
