package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.entity.IMimeType;
import jp.sourceforge.shovel.entity.impl.MimeTypeImpl;

@S2Dao(bean = MimeTypeImpl.class)
public interface IMimeTypeDao {
    int insert(IMimeType o);
    @Arguments("mimeTypeIds")
    void deleteByIds(long[] mimeTypeIds);
    void update(IMimeType o);

    @Arguments({"offset", "limit"})
    IMimeType[] findAll(long offset, long limit);
    @Arguments("extension")
    IMimeType findByName(String extension);
}
