package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.SessionConst.*;
import static jp.sourceforge.shovel.ViewType.*;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.action.ISearchUsersAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IUsersForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class SearchUsersActionImpl implements ISearchUsersAction {
    IUsersForm actionForm_;
    ServletContext context_;
    S2Container container_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        
        IListRefine listRefine = (IListRefine)getSession().getAttribute(S_LIST_REFINE);
        if (listRefine == null || !listRefine.getViewType().isSearchUsers()) {
            listRefine = (IListRefine)container_.getComponent(IListRefine.class);
            getSession().setAttribute(S_LIST_REFINE, listRefine);
        } else if (actionForm_.getMethodType().isPage()) {
            listRefine.setPage(actionForm_.getPage());
        }
        listRefine.setViewType(SEARCH_USERS);
        
        String keyword = actionForm_.getKeyword();
        if (keyword == null || keyword.length() <= 0) {
            listRefine.setPage(0);
        } else {
            request_.setAttribute("keyword", keyword);
            
            int page = listRefine.getPage();
            int limit = 0;
            
            //int page = actionForm_.getPage();
            //int limit = actionForm_.getCount();
            
            IUser[] temp = directoryService.searchUsers(keyword, page, limit);
            IUser[] users = shovelService.prepareForView(temp, limit);

            if (users != null && users.length > 0) {
                request_.setAttribute("nextPage", temp.length > users.length);
                request_.setAttribute("users", users);
                
                long[] userIds = new long[users.length];
                int i = 0;
                for (IUser tmp : users) {
                    userIds[i++] = tmp.getUserId();
                }
                
                IStatus[] statuses = shovelService.getRecents(userIds);
                Map<String, IStatus> statusMap = new HashMap<String, IStatus>();
                for (IStatus status : statuses) {
                    String senderId = String.valueOf(status.getSenderId());
                    statusMap.put(senderId, status);
                }
                request_.setAttribute("statuses", statusMap);

                IUser user = directoryService.getLoginUser();
                Map<String, IFriendship> friendshipMap = new HashMap<String, IFriendship>();
                if (user != null) {
                    IFriendship[] friendships = shovelService.getFriends(userIds);
                    for (IFriendship friendship : friendships) {
                        String passiveId = String.valueOf(friendship.getPassiveId());
                        friendshipMap.put(passiveId, friendship);
                    }
                }
                request_.setAttribute("friends", friendshipMap);
            }
        }
        
        return actionForm_.isPartial() ? PARTIAL : FULL;
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setContext(ServletContext context) {
        context_ = context;
    }
    public void setUsersForm(IUsersForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
    HttpSession getSession() {
        return request_.getSession(true);
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
