package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.DelayExecutionType.*;
import static jp.sourceforge.shovel.SessionConst.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.action.IResendPasswordAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.device.IDelayExecutorContext;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IAccountForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.thread.DelayExecutorQueue;
import jp.sourceforge.shovel.util.HttpUtil;

public class ResendPasswordActionImpl implements IResendPasswordAction {
    IAccountForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    HttpSession session_;
    S2Container container_;
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IDirectoryService directoryService = getShovelService().getDirectoryService();
        IUser user = directoryService.getUser(actionForm_.getEmail(), true);
        
        IDelayExecutorContext context = (IDelayExecutorContext)container_.getComponent(IDelayExecutorContext.class);
        context.setDelayExecutionType(RESEND_PASSWORD);
        context.setUser(user);
        context.initServerName();
        context.setCommit(false);
        DelayExecutorQueue queue = (DelayExecutorQueue)container_.getComponent(DelayExecutorQueue.class);
        queue.pushContext(context);
        
        session_.setAttribute(S_NOTIFICATION, "notify.resendPassword");
        HttpUtil.sendRedirect(response_, "/");
        
        return null;
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setAccountForm(IAccountForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
