package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;

import net.arnx.jsonic.JSON;

import jp.sourceforge.shovel.action.IDesignAction;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IDesignForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IServerFileService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.ServerFileUtil;

public class DesignActionImpl implements IDesignAction {
    IDesignForm actionForm_;
    HttpServletRequest request_;
    
    class JSONBean {
        IUser user_;
        IServerFile backgroundImage_;
        
        public JSONBean(IUser user) {
            user_ = user;
            backgroundImage_ = user_.getBackgroundImage();
        }
        public boolean getDefaultDesign() {
            return user_.isDefaultDesign();
        }
        public String getBackgroundColor() {
            if (getDefaultDesign()) {
                return "00A1D9";
            }
            return user_.getBackgroundColorHex();
        }
        public String getColor() {
            if (getDefaultDesign()) {
                return "000000";
            }
            return user_.getColorHex();
        }
        public String getNameColor() {
            if (getDefaultDesign()) {
                return "000000";
            }
            return user_.getNameColorHex();
        }
        public String getLinkColor() {
            if (getDefaultDesign()) {
                return "0000FF";
            }
            return user_.getLinkColorHex();
        }
        public String getSidebarBackgroundColor() {
            if (getDefaultDesign()) {
                return "E0FF92";
            }
            return user_.getSidebarBackgroundColorHex();
        }
        public String getSidebarFrameColor() {
            if (getDefaultDesign()) {
                return "87BC44";
            }
            return user_.getSidebarFrameColorHex();
        }
        public IServerFile getBackgroundImage() {
            return backgroundImage_ == null ? null : backgroundImage_;
        }
        public boolean getTile() {
            return user_.isTile();
        }
    }
    
    public String perform() throws Exception {
        IDirectoryService directoryService = getShovelService().getDirectoryService();
        IUser user = directoryService.getLoginUser();
        
        boolean defaultDesign = actionForm_.isDefaultDesign();
        user.setDefaultDesign(defaultDesign);
        
        if (!defaultDesign) {
            IServerFile oldServerFile = user.getBackgroundImage();
            IServerFile newServerFile = ServerFileUtil.toServerFile(actionForm_.getFile(), null, null);
            IServerFileService serverFileService = getShovelService().getServerFileService();

            if (oldServerFile.isExists()) {
                if (newServerFile.isExists() || actionForm_.isDestroyFile()) {
                    serverFileService.removeServerFile(oldServerFile);
                } else {
                    getShovelService().prepareForView(user);
                }
            }
            if (newServerFile.isExists()) {
                serverFileService.createServerFile(newServerFile, false, false);
                user.setBackgroundImage(newServerFile);
            }
            user.setTile(actionForm_.isTile());
            user.setBackgroundColorHex(actionForm_.getBackgroundColor());
            user.setColorHex(actionForm_.getColor());
            user.setNameColorHex(actionForm_.getNameColor());
            user.setLinkColorHex(actionForm_.getLinkColor());
            user.setSidebarBackgroundColorHex(actionForm_.getSidebarBackgroundColor());
            user.setSidebarFrameColorHex(actionForm_.getSidebarFrameColor());
        }
        
        directoryService.updateUser(user);
        
        String json = JSON.encode(new JSONBean(user));
        request_.setAttribute("content", "(" + json + ")");
        request_.setAttribute("callback", "window.parent.shovel.controller.applyDesign(eval($('#content').html()));");
        return SUCCESS;
    }
    public void setDesignForm(IDesignForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
}
