package jp.sourceforge.shovel;

public enum SortType {
    USER_ID             ("userId"),
    STATUS_ID           ("statusId"),
    STATUSES            ("statuses"),
    GIVEN_FAVORITES     ("givenFavorites");
    
    String sort_;
    
    SortType(String sort) {
        sort_ = sort;
    }
    public String getSort() {
        return sort_;
    }
    public static SortType find(String sort) {
        for (SortType type :values()) {
            if (sort.compareToIgnoreCase(type.getSort()) == 0) {
                return type;
            }
        }
        return null;
    }
    public boolean isUserId() {
        return this == USER_ID;
    }
    public boolean isStatusId() {
        return this == STATUS_ID;
    }
    public boolean isStatuses() {
        return this == STATUSES;
    }
    public boolean isGivenFavorites() {
        return this == GIVEN_FAVORITES;
    }
}
