package jp.sourceforge.shovel;

public enum SizeType {
    X_LARGE     ("xlarge",      73, 0),
    LARGE       ("large",       48, 1),
    MIDDLE      ("middle",      31, 2),
    SMALL       ("small",       24, 3),
    ORIGINAL    ("original",    500, -1);
    
    
    String id_;
    int px_;
    int index_;
    
    SizeType(String id, int px, int index) {
        id_ = id;
        px_ = px;
        index_ = index;
    }
    public String getId() {
        return id_;
    }
    public int getPx() {
        return px_;
    }
    public int getIndex() {
        return index_;
    }
    public static SizeType find(String id) {
        for (SizeType type :SizeType.values()) {
            if (id.compareToIgnoreCase(type.getId()) == 0) {
                return type;
            }
        }
        return null;
    }
    public boolean isXLarge() {
        return this == X_LARGE;
    }
    public boolean isLarge() {
        return this == LARGE;
    }
    public boolean isMiddle() {
        return this == MIDDLE;
    }
    public boolean isSmall() {
        return this == SMALL;
    }
    public boolean isOriginal() {
        return this == ORIGINAL;
    }
}
