package jp.sourceforge.shovel;

public enum SearchFriendsType {
    FOLLOWING           (0),
    RECIPROCAL_FOLLOW   (1),
    FOLLOWING_ONLY      (2),
    FOLLOWERS_ONLY      (3);

    int id_;
    SearchFriendsType(int id) {
        id_ = id;
    }
    public int getId() {
        return id_;
    }
    public static SearchFriendsType find(int id) {
        for (SearchFriendsType type : values()) {
            if (type.getId() == id) {
                return type;
            }
        }
        return FOLLOWING;
    }
    public boolean isFollowing() {
        return this == FOLLOWING;
    }
    public boolean isReciprocalFollow() {
        return this == RECIPROCAL_FOLLOW;
    }
    public boolean isFollowingOnly() {
        return this == FOLLOWING_ONLY;
    }
    public boolean isFollowersOnly() {
        return this == FOLLOWERS_ONLY;
    }
}
