package jp.sourceforge.shovel;

public enum RepliesType {
    ALWAYS          ("always",      0),
    FRIENDS         ("friends",     1),
    NEVER           ("never",       2);
    
    String key_;
    int id_;
    
    
    RepliesType(String key, int id) {
        key_ = key;
        id_ = id;
    }
    public String getKey() {
        return key_;
    }
    public int getId() {
        return id_;
    }
    public static RepliesType find(int id) {
        for(RepliesType type :RepliesType.values()) {
            if(type.getId() == id) {
                return type;
            }
        }
        return ALWAYS;
    }
    public static RepliesType find(String key) {
        for(RepliesType type :RepliesType.values()) {
            if (key.compareToIgnoreCase(type.getKey()) == 0) {
                return type;
            }
        }
        return ALWAYS;
    }
    public boolean isAlways() {
        return this == ALWAYS;
    }
    public boolean isFriends() {
        return this == FRIENDS;
    }
    public boolean isNever() {
        return this == NEVER;
    }
}
